/*
 * Decompiled with CFR 0.152.
 */
package com.github.ayltai.gradle.plugin;

import com.github.ayltai.gradle.plugin.SpringGraalNativePlugin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.LoggerFactory;

public class SpringGraalNativeTask
extends Exec {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(SpringGraalNativeTask.class);
    protected static final String DIR_OUTPUT = "native";
    private static final String DIR_BOOT_INF = "BOOT-INF";
    private static final String DIR_META_INF = "META-INF";
    private static final String FILE_MANIFEST = "MANIFEST.MF";
    private static final int BUFFER_SIZE = 4096;
    protected final Property<Boolean> traceClassInitialization = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> removeSaturatedTypeFlows = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> reportExceptionStackTraces = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> printAnalysisCallTree = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> enabledAllSecurityServices = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> staticallyLinked = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> verbose = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> warnMissingSelectorHints = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> removeUnusedAutoConfig = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> removeYamlSupport = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> removeXmlSupport = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> removeSpelSupport = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> removeJmxSupport = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> verify = this.getProject().getObjects().property(Boolean.class);
    protected final Property<Boolean> springNativeVerbose = this.getProject().getObjects().property(Boolean.class);
    protected final Property<String> springNativeMode = this.getProject().getObjects().property(String.class);
    protected final Property<String> dumpConfig = this.getProject().getObjects().property(String.class);
    protected final Property<String> mainClassName = this.getProject().getObjects().property(String.class);
    protected final Property<String> maxHeapSize = this.getProject().getObjects().property(String.class);
    protected final ListProperty<String> initializeAtBuildTime = this.getProject().getObjects().listProperty(String.class);

    public SpringGraalNativeTask() {
        this.setGroup("build");
        this.setDescription("Support for building Spring Boot applications as GraalVM native images");
    }

    @Nonnull
    protected String getClassPath(@Nonnull String classesPath, @Nonnull File outputDir) {
        File[] files = Paths.get(outputDir.getAbsolutePath(), DIR_BOOT_INF, "lib").toFile().listFiles();
        return files == null ? classesPath : classesPath + (OperatingSystem.current().isWindows() ? ";" : ":") + Stream.of(files).map(File::getAbsolutePath).collect(Collectors.joining(OperatingSystem.current().isWindows() ? ";" : ":"));
    }

    @Nonnull
    protected Iterable<String> getCommandLineArgs(@Nonnull String classPath) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(OperatingSystem.current().isWindows() ? "native-image.cmd" : "native-image");
        args.add("--allow-incomplete-classpath");
        args.add("--report-unsupported-elements-at-runtime");
        args.add("--no-fallback");
        args.add("--no-server");
        args.add("--install-exit-handlers");
        SpringGraalNativeTask.appendCommandLineArg(args, "-H:+TraceClassInitialization", this.traceClassInitialization);
        SpringGraalNativeTask.appendCommandLineArg(args, "-H:+RemoveSaturatedTypeFlows", this.removeSaturatedTypeFlows);
        SpringGraalNativeTask.appendCommandLineArg(args, "-H:+ReportExceptionStackTraces", this.reportExceptionStackTraces);
        SpringGraalNativeTask.appendCommandLineArg(args, "-H:+PrintAnalysisCallTree", this.printAnalysisCallTree);
        SpringGraalNativeTask.appendCommandLineArg(args, "--enable-all-security-services", this.enabledAllSecurityServices);
        SpringGraalNativeTask.appendCommandLineArg(args, "--static", this.staticallyLinked);
        SpringGraalNativeTask.appendCommandLineArg(args, "--verbose", this.verbose);
        SpringGraalNativeTask.appendCommandLineArg(args, "-Dspring.native.missing-selector-hints=warning", this.warnMissingSelectorHints);
        SpringGraalNativeTask.appendCommandLineArg(args, "-Dspring.native.remove-unused-autoconfig=true", this.removeUnusedAutoConfig);
        if (this.removeYamlSupport.isPresent()) {
            args.add("-Dspring.native.remove-yaml-support=" + this.removeYamlSupport.get());
        }
        if (this.removeXmlSupport.isPresent()) {
            args.add("-Dspring.native.remove-xml-support=" + this.removeXmlSupport.get());
        }
        if (this.removeSpelSupport.isPresent()) {
            args.add("-Dspring.native.remove-spel-support=" + this.removeSpelSupport.get());
        }
        if (this.removeJmxSupport.isPresent()) {
            args.add("-Dspring.native.remove-jmx-support=" + this.removeJmxSupport.get());
        }
        if (this.verify.isPresent()) {
            args.add("-Dspring.native.verify=" + this.verify.get());
        }
        if (this.springNativeVerbose.isPresent()) {
            args.add("-Dspring.native.verbose=" + this.springNativeVerbose.get());
        }
        if (this.springNativeMode.isPresent()) {
            args.add("-Dspring.native.mode=" + (String)this.springNativeMode.get());
        }
        if (this.maxHeapSize.isPresent() && !((String)this.maxHeapSize.get()).isEmpty()) {
            args.add("-J-Xmx" + (String)this.maxHeapSize.get());
        }
        if (this.initializeAtBuildTime.isPresent() && !((List)this.initializeAtBuildTime.get()).isEmpty()) {
            args.add("--initialize-at-build-time=" + String.join((CharSequence)",", (Iterable)this.initializeAtBuildTime.get()));
        }
        args.add("-H:Name=" + this.getProject().getName());
        args.add("-cp");
        args.add(classPath);
        args.add((String)this.mainClassName.get());
        if (LOGGER.isEnabled(LogLevel.DEBUG)) {
            LOGGER.debug(String.join((CharSequence)" ", args));
        }
        return args;
    }

    protected static void appendCommandLineArg(@Nonnull List<String> args, @Nonnull String arg, @Nonnull Property<Boolean> property) {
        if (Boolean.TRUE.equals(property.getOrNull())) {
            args.add(arg);
        }
    }

    @TaskAction
    protected void exec() {
        if (!this.mainClassName.isPresent()) {
            throw new InvalidUserDataException("mainClassName is null");
        }
        File outputDir = new File(this.getProject().getBuildDir().getAbsolutePath(), DIR_OUTPUT);
        try {
            Path classesPath = Paths.get(outputDir.getAbsolutePath(), DIR_BOOT_INF, "classes");
            this.deleteOutputDir(outputDir);
            this.copyFiles(classesPath, outputDir);
            ((Exec)this.workingDir(outputDir)).commandLine(this.getCommandLineArgs(this.getClassPath(classesPath.toString(), outputDir)));
            super.exec();
        }
        catch (IOException e) {
            throw new ResourceException(e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteOutputDir(@Nonnull File outputDir) throws IOException {
        if (outputDir.exists()) {
            LOGGER.info("Clear output directory");
            try (Stream<Path> stream = Files.walk(outputDir.toPath(), new FileVisitOption[0]);){
                stream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(file -> {
                    try {
                        Files.deleteIfExists(file.toPath());
                    }
                    catch (IOException e) {
                        throw new ResourceException("Failed to delete directory or file: " + file.getAbsolutePath(), (Throwable)e);
                    }
                });
            }
        } else {
            LOGGER.info("Skip clearing output directory as it does not exist");
        }
    }

    protected void copyFiles(@Nonnull Path classesPath, @Nonnull File outputDir) {
        try {
            this.explodeJar(((RegularFile)((Jar)SpringGraalNativePlugin.getDependency(this.getProject())).getArchiveFile().get()).getAsFile(), outputDir);
            LOGGER.info("Copy dependencies to output directory");
            File destination = new File(classesPath.toString(), DIR_META_INF);
            if (!destination.exists() && !destination.mkdirs()) {
                throw new ResourceException("Failed to create directory: " + destination.getAbsolutePath());
            }
            Files.copy(Paths.get(outputDir.getAbsolutePath(), DIR_META_INF, FILE_MANIFEST), Paths.get(classesPath.toString(), DIR_META_INF, FILE_MANIFEST), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new ResourceException(e.getMessage(), (Throwable)e);
        }
    }

    protected void explodeJar(@Nonnull File archive, @Nonnull File outputDir) throws IOException {
        LOGGER.info("Decompress dependencies");
        try (JarFile jarFile = new JarFile(archive);){
            jarFile.stream().sorted((entry1, entry2) -> (entry1.isDirectory() ? -1 : 0) + (entry2.isDirectory() ? 1 : 0)).forEachOrdered(entry -> {
                try {
                    this.explodeJarEntry(outputDir, jarFile, (JarEntry)entry);
                }
                catch (IOException e) {
                    throw new ResourceException("Failed to decompress JAR entry: " + entry.getName(), (Throwable)e);
                }
            });
        }
    }

    protected void explodeJarEntry(@Nonnull File outputDir, @Nonnull JarFile jarFile, @Nonnull JarEntry entry) throws IOException {
        File file = new File(outputDir, entry.getName());
        if (entry.isDirectory()) {
            if (!file.mkdirs()) {
                throw new IOException("Failed to create folder(s): " + file.getAbsolutePath());
            }
        } else {
            byte[] buffer = new byte[4096];
            try (BufferedInputStream inputStream = new BufferedInputStream(jarFile.getInputStream(entry));
                 BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                int length;
                while ((length = ((InputStream)inputStream).read(buffer)) >= 0) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
        }
    }
}

