/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.energizedwork.gradle.webdriver

import org.gradle.api.Project

class WebDriverBinariesPluginExtension {

    private final Project project

    final IeDriverServerConfiguration ieDriverServerConfiguration = new IeDriverServerConfiguration()

    File downloadRoot
    String chromedriver
    String geckodriver

    WebDriverBinariesPluginExtension(Project project) {
        this.project = project
    }

    void iedriverserver(String configuredVersion) {
        iedriverserver {
            version = configuredVersion
        }
    }

    void setIedriverserver(String configuredVersion) {
        iedriverserver {
            version = configuredVersion
        }
    }

    void iedriverserver(@DelegatesTo(IeDriverServerConfiguration) Closure configuration) {
        project.configure(ieDriverServerConfiguration, configuration)
    }
}
