/*
 * Decompiled with CFR 0.152.
 */
package com.digithurst.gradle.truststore;

import com.digithurst.gradle.truststore.TrustedCertificates;
import com.digithurst.gradle.truststore.Truststore;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.GradleScriptException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/digithurst/gradle/truststore/TruststorePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "customKeystore", "Ljava/io/File;", "getCustomKeystore", "()Ljava/io/File;", "customKeystore$delegate", "Lkotlin/Lazy;", "project", "apply", "", "setupStore", "Companion", "gradle-truststore-plugin"})
public final class TruststorePlugin
implements Plugin<Project> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private Project project;
    private final Lazy customKeystore$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ TruststorePlugin this$0;

        @NotNull
        public final File invoke() {
            return new File(TruststorePlugin.access$getProject$p(this.this$0).getBuildDir().toString() + "/truststores", "cacerts");
        }
        {
            this.this$0 = truststorePlugin;
            super(0);
        }
    }));
    private static final Logger logger;
    private static final List<String> keyStoreTypes;
    private static final List<String> certificateFactoryTypes;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TruststorePlugin.class), "customKeystore", "getCustomKeystore()Ljava/io/File;"))};
        Companion = new Companion(null);
        logger = Logging.getLogger(TruststorePlugin.class);
        keyStoreTypes = CollectionsKt.listOf((Object[])new String[]{"jks", "dks", "pkcs11", "pkcs12"});
        certificateFactoryTypes = CollectionsKt.listOf((Object)"X.509");
    }

    private final File getCustomKeystore() {
        Lazy lazy = this.customKeystore$delegate;
        TruststorePlugin truststorePlugin = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (File)lazy.getValue();
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        String javaHome = System.getProperty("java.home");
        logger.debug("Found Java home directory: " + javaHome);
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        String string = javaHome;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaHome");
        Truststore extension = new Truststore(file, string);
        project.getExtensions().add(Truststore.class, "truststore", (Object)extension);
        project.afterEvaluate((Action)new Action<Project>(this){
            final /* synthetic */ TruststorePlugin this$0;

            public final void execute(Project it) {
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                TruststorePlugin.access$setupStore(this.this$0, project);
            }
            {
                this.this$0 = truststorePlugin;
            }
        });
        logger.debug("Deferred setup of trust store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void setupStore(Project project) {
        boolean bl;
        Throwable it;
        Object object;
        String $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Truststore truststore = (Truststore)project.getExtensions().getByType(Truststore.class);
        File storeBaseFile = truststore.getBase().getStore$gradle_truststore_plugin();
        String storeBasePassword = truststore.getBase().getPassword$gradle_truststore_plugin();
        List<TrustedCertificates.TrustedCertificate> certificates = truststore.getCertificates$gradle_truststore_plugin();
        Iterable iterable = certificates;
        Collection collection = CollectionsKt.listOf((Object[])new Object[]{"Will try to assemble trust store from:", storeBaseFile});
        Object object2 = logger;
        boolean $i$f$map = false;
        Throwable throwable = $this$map$iv2;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Object object3 = $this$mapTo$iv$iv2.iterator();
        while (object3.hasNext()) {
            Object item$iv$iv = object3.next();
            TrustedCertificates.TrustedCertificate trustedCertificate = (TrustedCertificates.TrustedCertificate)item$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            String string = ((TrustedCertificates.TrustedCertificate)((Object)it)).getAlias() + ':' + ((TrustedCertificates.TrustedCertificate)((Object)it)).getPath();
            object.add(string);
        }
        object = (List)destination$iv$iv22;
        object2.debug(CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)), (CharSequence)"\n - ", null, null, (int)0, null, null, (int)62, null));
        if (truststore.isDefault$gradle_truststore_plugin()) {
            boolean $this$map$iv2 = storeBaseFile != null;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv2 = false;
            $this$mapTo$iv$iv2 = false;
            boolean destination$iv$iv22 = false;
            if (!$this$map$iv2) {
                bl = false;
                String destination$iv$iv22 = "Check failed.";
                throw (Throwable)new IllegalStateException(destination$iv$iv22.toString());
            }
            logger.debug("Using default trust store: " + storeBaseFile.getAbsolutePath());
        } else if (storeBaseFile != null && certificates.isEmpty()) {
            if (!storeBaseFile.isFile()) {
                throw (Throwable)new InvalidUserCodeException("Key store file does not exist: " + storeBaseFile.getAbsolutePath());
            }
            System.setProperty("javax.net.ssl.trustStore", storeBaseFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", storeBasePassword);
            logger.debug("Using custom trust store: " + storeBaseFile.getAbsolutePath());
        } else {
            File targetFile = this.getCustomKeystore();
            try {
                KeyStore ks = null;
                if (storeBaseFile != null) {
                    if (!storeBaseFile.isFile()) {
                        throw (Throwable)new InvalidUserCodeException("Trust store file does not exist: " + storeBaseFile.getAbsolutePath());
                    }
                    logger.debug("Importing key store " + storeBaseFile.getAbsoluteFile());
                    KeyStore keyStore = (KeyStore)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)keyStoreTypes), (Function1)((Function1)new Function1<String, KeyStore>(storeBaseFile, storeBasePassword){
                        final /* synthetic */ File $storeBaseFile;
                        final /* synthetic */ String $storeBasePassword;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Nullable
                        public final KeyStore invoke(@NotNull String ksType) {
                            Object object;
                            Intrinsics.checkParameterIsNotNull((Object)ksType, (String)"ksType");
                            try {
                                KeyStore keyStore;
                                TruststorePlugin.Companion.getLogger$gradle_truststore_plugin().debug("Trying to load trust store as " + ksType);
                                object = new FileInputStream(this.$storeBaseFile.getAbsoluteFile());
                                boolean bl = false;
                                Throwable throwable = null;
                                try {
                                    FileInputStream storeIn = (FileInputStream)object;
                                    boolean bl2 = false;
                                    KeyStore store = KeyStore.getInstance(ksType);
                                    String string = this.$storeBasePassword;
                                    InputStream inputStream = storeIn;
                                    KeyStore keyStore2 = store;
                                    boolean bl3 = false;
                                    String string2 = string;
                                    if (string2 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    char[] cArray = string2.toCharArray();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                                    char[] cArray2 = cArray;
                                    keyStore2.load(inputStream, cArray2);
                                    keyStore = store;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                                }
                                object = keyStore;
                            }
                            catch (Throwable t) {
                                Object v2;
                                Throwable throwable = t;
                                if (throwable instanceof KeyStoreException || throwable instanceof NoSuchAlgorithmException) {
                                    TruststorePlugin.Companion.getLogger$gradle_truststore_plugin().debug("Trust store is not of type " + ksType);
                                    v2 = null;
                                } else if (throwable instanceof CertificateException || throwable instanceof IOException) {
                                    TruststorePlugin.Companion.getLogger$gradle_truststore_plugin().error("Loading trust store failed", t);
                                    v2 = null;
                                } else {
                                    throw t;
                                }
                                object = v2;
                            }
                            return object;
                        }
                        {
                            this.$storeBaseFile = file;
                            this.$storeBasePassword = string;
                            super(1);
                        }
                    })));
                    if (keyStore == null) {
                        throw (Throwable)new KeyStoreException("No provider could load " + storeBaseFile.getAbsoluteFile());
                    }
                    ks = keyStore;
                    logger.debug("Imported trust store of type " + ks.getType());
                } else {
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    Intrinsics.checkExpressionValueIsNotNull((Object)keyStore, (String)"KeyStore.getInstance(KeyStore.getDefaultType())");
                    ks = keyStore;
                    $this$mapTo$iv$iv2 = storeBasePassword;
                    collection = null;
                    object2 = ks;
                    boolean destination$iv$iv22 = false;
                    String string = $this$mapTo$iv$iv2;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray = string.toCharArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    object = cArray;
                    ((KeyStore)object2).load((InputStream)((Object)collection), (char[])object);
                }
                boolean $this$mapTo$iv$iv2 = certificateFactoryTypes.size() == 1;
                boolean destination$iv$iv22 = false;
                bl = false;
                if (!$this$mapTo$iv$iv2) {
                    boolean bl3 = false;
                    String string = "Need to refactor to account for multiple possible certificate types";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                CertificateFactory cf = CertificateFactory.getInstance(certificateFactoryTypes.get(0));
                for (TrustedCertificates.TrustedCertificate cert : certificates) {
                    logger.debug("Importing certificate " + cert.getPath());
                    object3 = new FileInputStream(cert.getPath());
                    boolean item$iv$iv = false;
                    it = null;
                    try {
                        FileInputStream certIn = (FileInputStream)object3;
                        boolean bl4 = false;
                        ks.setCertificateEntry(cert.getAlias(), cf.generateCertificate(certIn));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        it = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)it);
                    }
                }
                logger.debug("Writing custom trust store to " + targetFile.getAbsolutePath());
                Path path = targetFile.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"targetFile.toPath()");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Closeable closeable = new FileOutputStream(targetFile);
                boolean bl5 = false;
                object3 = null;
                try {
                    FileOutputStream storeOut = (FileOutputStream)closeable;
                    boolean bl6 = false;
                    String string = storeBasePassword;
                    OutputStream outputStream = storeOut;
                    KeyStore keyStore = ks;
                    boolean bl7 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray = string2.toCharArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                    char[] cArray2 = cArray;
                    keyStore.store(outputStream, cArray2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    object3 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
            }
            catch (Throwable t) {
                throwable = t;
                if (throwable instanceof CertificateException || throwable instanceof KeyStoreException || throwable instanceof IOException || throwable instanceof NoSuchAlgorithmException) {
                    logger.error("Could not assemble trust store", t);
                    throw (Throwable)new GradleScriptException("Could not assemble trust store", t);
                }
                throw t;
            }
            System.setProperty("javax.net.ssl.trustStore", targetFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", storeBasePassword);
            logger.debug("Using aggregated custom trust store: " + targetFile.getAbsolutePath());
        }
    }

    public static final /* synthetic */ void access$setupStore(TruststorePlugin $this, Project project) {
        $this.setupStore(project);
    }

    public static final /* synthetic */ Project access$getProject$p(TruststorePlugin $this) {
        Project project = $this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public static final /* synthetic */ void access$setProject$p(TruststorePlugin $this, Project project) {
        $this.project = project;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/digithurst/gradle/truststore/TruststorePlugin$Companion;", "", "()V", "certificateFactoryTypes", "", "", "keyStoreTypes", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger$gradle_truststore_plugin", "()Lorg/gradle/api/logging/Logger;", "gradle-truststore-plugin"})
    public static final class Companion {
        public final Logger getLogger$gradle_truststore_plugin() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

