/*
 * Decompiled with CFR 0.152.
 */
package gr.loukaspd.multiselectautocomplete;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.util.ArrayList;

class Helpers {
    public static final String TAG = "MultiselectAutocomplete";

    Helpers() {
    }

    public static View inflateView(Context context, int layoutRes) {
        try {
            return LayoutInflater.from((Context)context).inflate(layoutRes, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Could not inflate the specified Layout Resource File");
            return null;
        }
    }

    public static void releaseFocus(EditText view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void requestFocus(EditText editText) {
        editText.requestFocus();
        InputMethodManager imm = (InputMethodManager)editText.getContext().getSystemService("input_method");
        imm.showSoftInput((View)editText, 1);
    }

    public static <T> ArrayList<T> cloneList(ArrayList<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(list);
        return result;
    }

    static Drawable convertViewToDrawable(View view, Resources resources) {
        int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(spec, spec);
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap b = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        c.translate((float)(-view.getScrollX()), (float)(-view.getScrollY()));
        view.draw(c);
        view.setDrawingCacheEnabled(true);
        Bitmap cacheBmp = view.getDrawingCache();
        Bitmap viewBmp = cacheBmp.copy(Bitmap.Config.ARGB_8888, true);
        view.destroyDrawingCache();
        return new BitmapDrawable(resources, viewBmp);
    }
}

