/*
 * Decompiled with CFR 0.152.
 */
package gr.loukaspd.multiselectautocomplete;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import gr.loukaspd.multiselectautocomplete.Helpers;
import gr.loukaspd.multiselectautocomplete.Interfaces.IMultiSelectUi;
import gr.loukaspd.multiselectautocomplete.ViewHolderAutocomplete;
import java.util.ArrayList;

class AdapterAutocomplete<T>
extends RecyclerView.Adapter {
    private final OnItemClicked<T> _onItemClicked;
    private ArrayList<T> _items;
    private ArrayList<T> _currentItems;
    private String _filter;
    private final IMultiSelectUi<T> _ui;

    public AdapterAutocomplete(IMultiSelectUi<T> ui, ArrayList<T> items, OnItemClicked<T> onItemClicked) {
        this._ui = ui;
        this._onItemClicked = onItemClicked;
        this._items = Helpers.cloneList(items);
        this.applyFiltering(null);
    }

    public void setFilter(String text) {
        this.applyFiltering(text);
        this.notifyDataSetChanged();
    }

    public void removeItem(T item) {
        if (!this._items.remove(item)) {
            return;
        }
        this.applyFiltering(this._filter);
    }

    public void addItem(T item) {
        if (this._items.contains(item)) {
            return;
        }
        this._items.add(item);
        this.applyFiltering(this._filter);
    }

    public void setItems(ArrayList<T> items) {
        this._items = Helpers.cloneList(items);
        this.applyFiltering(this._filter);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this._ui.autocompleteLayoutRes(), null);
        final ViewHolderAutocomplete viewHolder = new ViewHolderAutocomplete(view);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AdapterAutocomplete.this._onItemClicked.onClick(viewHolder.Item);
            }
        });
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        T item = this._currentItems.get(position);
        ViewHolderAutocomplete viewHolder = (ViewHolderAutocomplete)holder;
        viewHolder.Item = item;
        this._ui.autocompleteUpdateView(viewHolder.getView(), item);
    }

    public int getItemCount() {
        return this._currentItems.size();
    }

    private void applyFiltering(String filter) {
        this._currentItems = new ArrayList();
        for (T item : this._items) {
            if (filter != null && !this._ui.getItemText(item).toLowerCase().contains(filter.toLowerCase())) continue;
            this._currentItems.add(item);
        }
        this._filter = filter;
    }

    static interface OnItemClicked<T> {
        public void onClick(T var1);
    }
}

