/*
 * Decompiled with CFR 0.152.
 */
package gr.loukaspd.multiselectautocomplete;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;
import com.otaliastudios.autocomplete.Autocomplete;
import com.otaliastudios.autocomplete.AutocompleteCallback;
import com.otaliastudios.autocomplete.AutocompletePolicy;
import gr.loukaspd.multiselectautocomplete.AutocompletePresenter;
import gr.loukaspd.multiselectautocomplete.Helpers;
import gr.loukaspd.multiselectautocomplete.Interfaces.IMultiSelectItem;
import gr.loukaspd.multiselectautocomplete.Interfaces.IMultiSelectUi;
import gr.loukaspd.multiselectautocomplete.MultiSelectEditTextTagSpan;
import gr.loukaspd.multiselectautocomplete.R;
import java.util.ArrayList;
import java.util.List;

public class MultiSelectAutocomplete<T extends IMultiSelectItem>
extends MultiAutoCompleteTextView
implements AutocompleteCallback {
    private boolean _supportMultiple = false;
    private boolean _showOptionsOnFocus = false;
    private boolean _clearUnmatchedText = false;
    private final List<MultiSelectEditTextTagSpan<T>> _tagSpans = new ArrayList<MultiSelectEditTextTagSpan<T>>();
    private String _lastString = "";
    private boolean _isAfterTextWatcherEnabled = true;
    private CharSequence _query = "";
    private Autocomplete _autocomplete;
    private IMultiSelectUi<T> _ui;
    private AutocompletePresenter<T> _presenter;
    private OnSelectedItemsChangedListener _onSelectedItemsChanged;
    private final TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable str) {
            MultiSelectEditTextTagSpan toRemoveSpan;
            boolean isDeleting;
            if (!MultiSelectAutocomplete.this._isAfterTextWatcherEnabled) {
                return;
            }
            boolean bl = isDeleting = MultiSelectAutocomplete.this._lastString.length() > str.length();
            if (MultiSelectAutocomplete.this._lastString.endsWith(" ") && !str.toString().endsWith("\n") && isDeleting && !MultiSelectAutocomplete.this._tagSpans.isEmpty() && (toRemoveSpan = (MultiSelectEditTextTagSpan)((Object)MultiSelectAutocomplete.this._tagSpans.get(MultiSelectAutocomplete.this._tagSpans.size() - 1))).getPosition() + toRemoveSpan.getSource().length() == str.length()) {
                MultiSelectAutocomplete.this.removeTagSpan(toRemoveSpan, false);
            }
            MultiSelectAutocomplete.this._lastString = str.toString();
        }
    };

    public void setSupportMultiple(boolean supportMultiple) {
        this._supportMultiple = supportMultiple;
    }

    public void setShowOptionsOnFocus(boolean showOptionsOnFocus) {
        this._showOptionsOnFocus = showOptionsOnFocus;
    }

    public void setClearUnmatchedText(boolean clearUnmatchedText) {
        this._clearUnmatchedText = clearUnmatchedText;
    }

    public MultiSelectAutocomplete(Context context) {
        super(context);
        this.init(context, null);
    }

    public MultiSelectAutocomplete(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MultiSelectAutocomplete(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        this.setSelection(this.length());
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            if (this._showOptionsOnFocus && this._autocomplete != null) {
                this._autocomplete.showPopup(this._query);
            }
        } else if (this._clearUnmatchedText) {
            this.clearUnmatchedText();
        }
    }

    public void initialize(IMultiSelectUi<T> ui, ArrayList<T> items) {
        this._ui = ui;
        this.initializeAutocomplete(items);
    }

    public ArrayList<T> getSelectedItems() {
        ArrayList<T> items = new ArrayList<T>(this._tagSpans.size());
        for (MultiSelectEditTextTagSpan<T> span : this._tagSpans) {
            items.add(span.getItem());
        }
        return items;
    }

    public T getSelectedItem() {
        if (this._tagSpans.size() < 1) {
            return null;
        }
        return this._tagSpans.get(0).getItem();
    }

    public void addSelectedItem(T item) {
        if (!this._supportMultiple) {
            this._tagSpans.clear();
        }
        this.addItem(item);
    }

    public boolean removeSelectedItem(T item) {
        for (int i = 0; i < this._tagSpans.size(); ++i) {
            MultiSelectEditTextTagSpan<T> span = this._tagSpans.get(i);
            if (span.getItem() != item) continue;
            this._tagSpans.remove(i);
            this.updateText();
            this.toggleEnabled(true);
            return true;
        }
        return false;
    }

    public void clear() {
        this._tagSpans.clear();
        this.updateText();
        this.toggleEnabled(true);
    }

    public void setAutocompleteItems(ArrayList<T> items) {
        this.clear();
        this._presenter.setItems(items);
    }

    public void setOnSelectedItemsChangedListener(OnSelectedItemsChangedListener listener) {
        this._onSelectedItemsChanged = listener;
    }

    private void initializeAutocomplete(ArrayList<T> items) {
        this._presenter = new AutocompletePresenter<T>(this.getContext(), this._ui, items);
        this._autocomplete = Autocomplete.on((EditText)this).with(new AutocompletePolicy(){

            public boolean shouldShowPopup(Spannable text, int cursorPos) {
                return this.getQuery(text).length() > 0;
            }

            public boolean shouldDismissPopup(Spannable text, int cursorPos) {
                return !this.shouldShowPopup(text, cursorPos);
            }

            public CharSequence getQuery(Spannable text) {
                MultiSelectEditTextTagSpan[] spans = (MultiSelectEditTextTagSpan[])text.getSpans(0, text.length(), MultiSelectEditTextTagSpan.class);
                MultiSelectAutocomplete.this._query = text.toString();
                for (MultiSelectEditTextTagSpan span : spans) {
                    int charsToRemove = span.getSource().length() + 1;
                    if (charsToRemove > MultiSelectAutocomplete.this._query.length()) {
                        MultiSelectAutocomplete.this._query = "";
                        continue;
                    }
                    MultiSelectAutocomplete.this._query = MultiSelectAutocomplete.this._query.subSequence(charsToRemove, MultiSelectAutocomplete.this._query.length());
                }
                return MultiSelectAutocomplete.this._query;
            }

            public void onDismiss(Spannable text) {
            }
        }).with(this._presenter).with((AutocompleteCallback)this).build();
        this._autocomplete.setGravity(0x800005);
    }

    void addItem(T item) {
        View view = this.getView(item);
        Drawable bd = this.convertViewToDrawable(view);
        bd.setBounds(0, 0, bd.getIntrinsicWidth(), bd.getIntrinsicHeight());
        MultiSelectEditTextTagSpan<T> span = new MultiSelectEditTextTagSpan<T>(bd, item.getText());
        span.setItem(item);
        int spansSize = this._tagSpans.size();
        if (spansSize == 0) {
            span.setIndex(0);
            span.setPosition(0);
        } else {
            span.setIndex(spansSize);
            MultiSelectEditTextTagSpan<T> lastSpan = this._tagSpans.get(this._tagSpans.size() - 1);
            span.setPosition(lastSpan.getPosition() + lastSpan.getItemText().length() + 1);
        }
        this._tagSpans.add(span);
        this.updateText();
        if (this._onSelectedItemsChanged != null) {
            this._onSelectedItemsChanged.onSelectedItemsChanged();
        }
    }

    private void updateText() {
        this._isAfterTextWatcherEnabled = false;
        SpannableStringBuilder sb = new SpannableStringBuilder();
        for (MultiSelectEditTextTagSpan<T> tagSpan : this._tagSpans) {
            this.addTagSpan(sb, tagSpan);
        }
        this.getText().clear();
        this.getText().append((CharSequence)sb);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setSelection(sb.length());
        this._lastString = sb.toString();
        this._isAfterTextWatcherEnabled = true;
    }

    private void toggleEnabled(boolean enabled) {
        if (this._supportMultiple) {
            return;
        }
        if (!enabled) {
            Helpers.releaseFocus((EditText)this);
            this.clearFocus();
            this.setFocusableInTouchMode(false);
            this.setFocusable(false);
        } else {
            this.setFocusableInTouchMode(true);
            Helpers.requestFocus((EditText)this);
        }
    }

    private void clearUnmatchedText() {
        this.updateText();
    }

    public boolean onPopupItemClicked(Editable editable, Object item) {
        this.addItem((IMultiSelectItem)item);
        return true;
    }

    public void onPopupVisibilityChanged(boolean shown) {
    }

    private void addTagSpan(SpannableStringBuilder sb, final MultiSelectEditTextTagSpan<T> tagSpan) {
        String source = tagSpan.getSource();
        sb.append((CharSequence)source).append((CharSequence)" ");
        int length = sb.length();
        int startSpan = length - source.length() - 1;
        int endSpan = length - 1;
        sb.setSpan(tagSpan, startSpan, endSpan, 33);
        sb.setSpan((Object)new ClickableSpan(){

            public void onClick(View widget) {
                MultiSelectAutocomplete.this.removeTagSpan(tagSpan, true);
            }
        }, startSpan, endSpan, 33);
        this._presenter.removeItem(tagSpan.getItem());
        this.toggleEnabled(false);
    }

    private void removeTagSpan(MultiSelectEditTextTagSpan<T> span, boolean includeSpace) {
        this._isAfterTextWatcherEnabled = false;
        int extraLength = includeSpace ? 1 : 0;
        int tagPosition = span.getPosition();
        int tagIndex = span.getIndex();
        int tagLength = span.getSource().length() + extraLength;
        this.getText().replace(tagPosition, tagPosition + tagLength, (CharSequence)"");
        int size = this._tagSpans.size();
        for (int i = tagIndex + 1; i < size; ++i) {
            MultiSelectEditTextTagSpan<T> tagSpan = this._tagSpans.get(i);
            tagSpan.setIndex(i - 1);
            tagSpan.setPosition(tagSpan.getPosition() - tagLength);
        }
        this._tagSpans.remove(tagIndex);
        this.post(new Runnable(){

            @Override
            public void run() {
                MultiSelectAutocomplete.this.setSelection(MultiSelectAutocomplete.this.length());
            }
        });
        this._isAfterTextWatcherEnabled = true;
        this._presenter.addItem(span.getItem());
        this.toggleEnabled(true);
        if (this._onSelectedItemsChanged != null) {
            this._onSelectedItemsChanged.onSelectedItemsChanged();
        }
    }

    private View getView(T item) {
        View view = Helpers.inflateView(this.getContext(), this._ui.selectedItemLayoutRes());
        if (view == null) {
            return null;
        }
        this._ui.selectedItemUpdateView(view, item);
        return view;
    }

    private Drawable convertViewToDrawable(View view) {
        int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(spec, spec);
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        Bitmap b = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        c.translate((float)(-view.getScrollX()), (float)(-view.getScrollY()));
        view.draw(c);
        view.setDrawingCacheEnabled(true);
        Bitmap cacheBmp = view.getDrawingCache();
        Bitmap viewBmp = cacheBmp.copy(Bitmap.Config.ARGB_8888, true);
        view.destroyDrawingCache();
        return new BitmapDrawable(this.getResources(), viewBmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MultiSelectAutocomplete, 0, 0);
        try {
            this._supportMultiple = a.getBoolean(R.styleable.MultiSelectAutocomplete_supportMultiple, false);
            this._showOptionsOnFocus = a.getBoolean(R.styleable.MultiSelectAutocomplete_showOptionsOnFocus, false);
            this._clearUnmatchedText = a.getBoolean(R.styleable.MultiSelectAutocomplete_clearUnmatchedText, false);
        }
        finally {
            a.recycle();
        }
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        MultiSelectAutocomplete.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        MultiSelectAutocomplete.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    MultiSelectAutocomplete.this.addTextChangedListener(MultiSelectAutocomplete.this.mTextWatcher);
                    MultiSelectAutocomplete.this.mTextWatcher.afterTextChanged(MultiSelectAutocomplete.this.getText());
                }
            });
        }
    }

    public static interface OnSelectedItemsChangedListener {
        public void onSelectedItemsChanged();
    }
}

