/*
 * Decompiled with CFR 0.152.
 */
package fr.coppernic.lib.splash;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

class MetaConfig {
    private static final String TAG = "MetaConfig";
    private static final String KEY_ACTIVITY = "activity";
    private static final String KEY_TIMING = "timing";
    private static final int DEFAULT_TIMING = 0;
    private int timing = 0;
    private Intent targetIntent;

    MetaConfig(@NonNull Activity activity) {
        try {
            ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 128);
            String targetActivity = info.metaData.getString(KEY_ACTIVITY);
            if (targetActivity == null) {
                throw new NullPointerException("Target activity is not defined in manifest's meta data");
            }
            this.timing = info.metaData.getInt(KEY_TIMING, 0);
            ComponentName componentName = new ComponentName(activity.getPackageName(), targetActivity);
            this.targetIntent = new Intent(activity.getIntent());
            this.targetIntent.setComponent(componentName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    int getTiming() {
        return this.timing;
    }

    @Nullable
    Intent getTargetIntent() {
        return this.targetIntent;
    }
}

