/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.android.R;
import com.facebook.internal.SessionTracker;
import com.facebook.model.GraphObject;
import com.facebook.widget.GraphObjectAdapter;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PickerFragment<T extends GraphObject>
extends Fragment {
    public static final String SHOW_PICTURES_BUNDLE_KEY = "com.facebook.widget.PickerFragment.ShowPictures";
    public static final String EXTRA_FIELDS_BUNDLE_KEY = "com.facebook.widget.PickerFragment.ExtraFields";
    public static final String SHOW_TITLE_BAR_BUNDLE_KEY = "com.facebook.widget.PickerFragment.ShowTitleBar";
    public static final String TITLE_TEXT_BUNDLE_KEY = "com.facebook.widget.PickerFragment.TitleText";
    public static final String DONE_BUTTON_TEXT_BUNDLE_KEY = "com.facebook.widget.PickerFragment.DoneButtonText";
    private static final String SELECTION_BUNDLE_KEY = "com.facebook.android.PickerFragment.Selection";
    private static final String ACTIVITY_CIRCLE_SHOW_KEY = "com.facebook.android.PickerFragment.ActivityCircleShown";
    private static final int PROFILE_PICTURE_PREFETCH_BUFFER = 5;
    private final int layout;
    private OnErrorListener onErrorListener;
    private OnDataChangedListener onDataChangedListener;
    private OnSelectionChangedListener onSelectionChangedListener;
    private OnDoneButtonClickedListener onDoneButtonClickedListener;
    private GraphObjectFilter<T> filter;
    private boolean showPictures = true;
    private boolean showTitleBar = true;
    private ListView listView;
    HashSet<String> extraFields = new HashSet();
    GraphObjectAdapter<T> adapter;
    private final Class<T> graphObjectClass;
    private LoadingStrategy loadingStrategy;
    private SelectionStrategy selectionStrategy;
    private ProgressBar activityCircle;
    private SessionTracker sessionTracker;
    private String titleText;
    private String doneButtonText;
    private TextView titleTextView;
    private Button doneButton;
    private Drawable titleBarBackground;
    private Drawable doneButtonBackground;
    private boolean appEventsLogged;
    private AbsListView.OnScrollListener onScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            PickerFragment.this.reprioritizeDownloads();
        }
    };

    PickerFragment(Class<T> graphObjectClass, int layout2, Bundle args) {
        this.graphObjectClass = graphObjectClass;
        this.layout = layout2;
        this.setPickerFragmentSettingsFromBundle(args);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.adapter = this.createAdapter();
        this.adapter.setFilter(new GraphObjectAdapter.Filter<T>(){

            @Override
            public boolean includeItem(T graphObject) {
                return PickerFragment.this.filterIncludesItem(graphObject);
            }
        });
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        TypedArray a = activity.obtainStyledAttributes(attrs, R.styleable.com_facebook_picker_fragment);
        this.setShowPictures(a.getBoolean(0, this.showPictures));
        String extraFieldsString = a.getString(1);
        if (extraFieldsString != null) {
            String[] strings = extraFieldsString.split(",");
            this.setExtraFields(Arrays.asList(strings));
        }
        this.showTitleBar = a.getBoolean(2, this.showTitleBar);
        this.titleText = a.getString(3);
        this.doneButtonText = a.getString(4);
        this.titleBarBackground = a.getDrawable(5);
        this.doneButtonBackground = a.getDrawable(6);
        a.recycle();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup view = (ViewGroup)inflater.inflate(this.layout, container, false);
        this.listView = (ListView)view.findViewById(R.id.com_facebook_picker_list_view);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                PickerFragment.this.onListItemClick((ListView)parent, v, position);
            }
        });
        this.listView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return false;
            }
        });
        this.listView.setOnScrollListener(this.onScrollListener);
        this.activityCircle = (ProgressBar)view.findViewById(R.id.com_facebook_picker_activity_circle);
        this.setupViews(view);
        this.listView.setAdapter(this.adapter);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.sessionTracker = new SessionTracker((Context)this.getActivity(), new Session.StatusCallback(){

            @Override
            public void call(Session session, SessionState state, Exception exception) {
                if (!session.isOpened()) {
                    PickerFragment.this.clearResults();
                }
            }
        });
        this.setSettingsFromBundle(savedInstanceState);
        this.loadingStrategy = this.createLoadingStrategy();
        this.loadingStrategy.attach(this.adapter);
        this.selectionStrategy = this.createSelectionStrategy();
        this.selectionStrategy.readSelectionFromBundle(savedInstanceState, SELECTION_BUNDLE_KEY);
        if (this.showTitleBar) {
            this.inflateTitleBar((ViewGroup)this.getView());
        }
        if (this.activityCircle != null && savedInstanceState != null) {
            boolean shown = savedInstanceState.getBoolean(ACTIVITY_CIRCLE_SHOW_KEY, false);
            if (shown) {
                this.displayActivityCircle();
            } else {
                this.hideActivityCircle();
            }
        }
    }

    public void onDetach() {
        super.onDetach();
        this.listView.setOnScrollListener(null);
        this.listView.setAdapter(null);
        this.loadingStrategy.detach();
        this.sessionTracker.stopTracking();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.saveSettingsToBundle(outState);
        this.selectionStrategy.saveSelectionToBundle(outState, SELECTION_BUNDLE_KEY);
        if (this.activityCircle != null) {
            outState.putBoolean(ACTIVITY_CIRCLE_SHOW_KEY, this.activityCircle.getVisibility() == 0);
        }
    }

    public void onStop() {
        if (!this.appEventsLogged) {
            this.logAppEvents(false);
        }
        super.onStop();
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
        this.setSettingsFromBundle(args);
    }

    public OnDataChangedListener getOnDataChangedListener() {
        return this.onDataChangedListener;
    }

    public void setOnDataChangedListener(OnDataChangedListener onDataChangedListener) {
        this.onDataChangedListener = onDataChangedListener;
    }

    public OnSelectionChangedListener getOnSelectionChangedListener() {
        return this.onSelectionChangedListener;
    }

    public void setOnSelectionChangedListener(OnSelectionChangedListener onSelectionChangedListener) {
        this.onSelectionChangedListener = onSelectionChangedListener;
    }

    public OnDoneButtonClickedListener getOnDoneButtonClickedListener() {
        return this.onDoneButtonClickedListener;
    }

    public void setOnDoneButtonClickedListener(OnDoneButtonClickedListener onDoneButtonClickedListener) {
        this.onDoneButtonClickedListener = onDoneButtonClickedListener;
    }

    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public GraphObjectFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(GraphObjectFilter<T> filter) {
        this.filter = filter;
    }

    public Session getSession() {
        return this.sessionTracker.getSession();
    }

    public void setSession(Session session) {
        this.sessionTracker.setSession(session);
    }

    public boolean getShowPictures() {
        return this.showPictures;
    }

    public void setShowPictures(boolean showPictures) {
        this.showPictures = showPictures;
    }

    public Set<String> getExtraFields() {
        return new HashSet<String>(this.extraFields);
    }

    public void setExtraFields(Collection<String> fields) {
        this.extraFields = new HashSet();
        if (fields != null) {
            this.extraFields.addAll(fields);
        }
    }

    public void setShowTitleBar(boolean showTitleBar) {
        this.showTitleBar = showTitleBar;
    }

    public boolean getShowTitleBar() {
        return this.showTitleBar;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public String getTitleText() {
        if (this.titleText == null) {
            this.titleText = this.getDefaultTitleText();
        }
        return this.titleText;
    }

    public void setDoneButtonText(String doneButtonText) {
        this.doneButtonText = doneButtonText;
    }

    public String getDoneButtonText() {
        if (this.doneButtonText == null) {
            this.doneButtonText = this.getDefaultDoneButtonText();
        }
        return this.doneButtonText;
    }

    public void loadData(boolean forceReload) {
        if (!forceReload && this.loadingStrategy.isDataPresentOrLoading()) {
            return;
        }
        this.loadDataSkippingRoundTripIfCached();
    }

    public void setSettingsFromBundle(Bundle inState) {
        this.setPickerFragmentSettingsFromBundle(inState);
    }

    void setupViews(ViewGroup view) {
    }

    boolean filterIncludesItem(T graphObject) {
        if (this.filter != null) {
            return this.filter.includeItem(graphObject);
        }
        return true;
    }

    List<T> getSelectedGraphObjects() {
        return this.adapter.getGraphObjectsById(this.selectionStrategy.getSelectedIds());
    }

    void setSelectedGraphObjects(List<String> objectIds) {
        for (String objectId : objectIds) {
            if (this.selectionStrategy.isSelected(objectId)) continue;
            this.selectionStrategy.toggleSelection(objectId);
        }
    }

    void saveSettingsToBundle(Bundle outState) {
        outState.putBoolean(SHOW_PICTURES_BUNDLE_KEY, this.showPictures);
        if (!this.extraFields.isEmpty()) {
            outState.putString(EXTRA_FIELDS_BUNDLE_KEY, TextUtils.join((CharSequence)",", this.extraFields));
        }
        outState.putBoolean(SHOW_TITLE_BAR_BUNDLE_KEY, this.showTitleBar);
        outState.putString(TITLE_TEXT_BUNDLE_KEY, this.titleText);
        outState.putString(DONE_BUTTON_TEXT_BUNDLE_KEY, this.doneButtonText);
    }

    abstract Request getRequestForLoadData(Session var1);

    abstract PickerFragmentAdapter<T> createAdapter();

    abstract LoadingStrategy createLoadingStrategy();

    abstract SelectionStrategy createSelectionStrategy();

    void onLoadingData() {
    }

    String getDefaultTitleText() {
        return null;
    }

    String getDefaultDoneButtonText() {
        return this.getString(R.string.com_facebook_picker_done_button_text);
    }

    void displayActivityCircle() {
        if (this.activityCircle != null) {
            this.layoutActivityCircle();
            this.activityCircle.setVisibility(0);
        }
    }

    void layoutActivityCircle() {
        float alpha = !this.adapter.isEmpty() ? 0.25f : 1.0f;
        PickerFragment.setAlpha((View)this.activityCircle, alpha);
    }

    void hideActivityCircle() {
        if (this.activityCircle != null) {
            this.activityCircle.clearAnimation();
            this.activityCircle.setVisibility(4);
        }
    }

    void setSelectionStrategy(SelectionStrategy selectionStrategy) {
        if (selectionStrategy != this.selectionStrategy) {
            this.selectionStrategy = selectionStrategy;
            if (this.adapter != null) {
                this.adapter.notifyDataSetChanged();
            }
        }
    }

    void logAppEvents(boolean doneButtonClicked) {
    }

    private static void setAlpha(View view, float alpha) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(alpha, alpha);
        alphaAnimation.setDuration(0L);
        alphaAnimation.setFillAfter(true);
        view.startAnimation((Animation)alphaAnimation);
    }

    private void setPickerFragmentSettingsFromBundle(Bundle inState) {
        if (inState != null) {
            String doneButtonTextString;
            this.showPictures = inState.getBoolean(SHOW_PICTURES_BUNDLE_KEY, this.showPictures);
            String extraFieldsString = inState.getString(EXTRA_FIELDS_BUNDLE_KEY);
            if (extraFieldsString != null) {
                String[] strings = extraFieldsString.split(",");
                this.setExtraFields(Arrays.asList(strings));
            }
            this.showTitleBar = inState.getBoolean(SHOW_TITLE_BAR_BUNDLE_KEY, this.showTitleBar);
            String titleTextString = inState.getString(TITLE_TEXT_BUNDLE_KEY);
            if (titleTextString != null) {
                this.titleText = titleTextString;
                if (this.titleTextView != null) {
                    this.titleTextView.setText((CharSequence)this.titleText);
                }
            }
            if ((doneButtonTextString = inState.getString(DONE_BUTTON_TEXT_BUNDLE_KEY)) != null) {
                this.doneButtonText = doneButtonTextString;
                if (this.doneButton != null) {
                    this.doneButton.setText((CharSequence)this.doneButtonText);
                }
            }
        }
    }

    private void inflateTitleBar(ViewGroup view) {
        ViewStub stub = (ViewStub)view.findViewById(R.id.com_facebook_picker_title_bar_stub);
        if (stub != null) {
            View titleBar = stub.inflate();
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(3, R.id.com_facebook_picker_title_bar);
            this.listView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.titleBarBackground != null) {
                titleBar.setBackgroundDrawable(this.titleBarBackground);
            }
            this.doneButton = (Button)view.findViewById(R.id.com_facebook_picker_done_button);
            if (this.doneButton != null) {
                this.doneButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PickerFragment.this.logAppEvents(true);
                        PickerFragment.this.appEventsLogged = true;
                        if (PickerFragment.this.onDoneButtonClickedListener != null) {
                            PickerFragment.this.onDoneButtonClickedListener.onDoneButtonClicked(PickerFragment.this);
                        }
                    }
                });
                if (this.getDoneButtonText() != null) {
                    this.doneButton.setText((CharSequence)this.getDoneButtonText());
                }
                if (this.doneButtonBackground != null) {
                    this.doneButton.setBackgroundDrawable(this.doneButtonBackground);
                }
            }
            this.titleTextView = (TextView)view.findViewById(R.id.com_facebook_picker_title);
            if (this.titleTextView != null && this.getTitleText() != null) {
                this.titleTextView.setText((CharSequence)this.getTitleText());
            }
        }
    }

    private void onListItemClick(ListView listView, View v, int position) {
        GraphObject graphObject = (GraphObject)listView.getItemAtPosition(position);
        String id2 = this.adapter.getIdOfGraphObject(graphObject);
        this.selectionStrategy.toggleSelection(id2);
        this.adapter.notifyDataSetChanged();
        if (this.onSelectionChangedListener != null) {
            this.onSelectionChangedListener.onSelectionChanged(this);
        }
    }

    private void loadDataSkippingRoundTripIfCached() {
        this.clearResults();
        Request request = this.getRequestForLoadData(this.getSession());
        if (request != null) {
            this.onLoadingData();
            this.loadingStrategy.startLoading(request);
        }
    }

    private void clearResults() {
        if (this.adapter != null) {
            boolean wasSelection = !this.selectionStrategy.isEmpty();
            boolean wasData = !this.adapter.isEmpty();
            this.loadingStrategy.clearResults();
            this.selectionStrategy.clear();
            this.adapter.notifyDataSetChanged();
            if (wasData && this.onDataChangedListener != null) {
                this.onDataChangedListener.onDataChanged(this);
            }
            if (wasSelection && this.onSelectionChangedListener != null) {
                this.onSelectionChangedListener.onSelectionChanged(this);
            }
        }
    }

    void updateAdapter(SimpleGraphObjectCursor<T> data) {
        if (this.adapter != null) {
            int newPositionOfItem;
            View view = this.listView.getChildAt(1);
            int anchorPosition = this.listView.getFirstVisiblePosition();
            if (anchorPosition > 0) {
                ++anchorPosition;
            }
            GraphObjectAdapter.SectionAndItem<T> anchorItem = this.adapter.getSectionAndItem(anchorPosition);
            int top = view != null && anchorItem.getType() != GraphObjectAdapter.SectionAndItem.Type.ACTIVITY_CIRCLE ? view.getTop() : 0;
            boolean dataChanged = this.adapter.changeCursor(data);
            if (view != null && anchorItem != null && (newPositionOfItem = this.adapter.getPosition(anchorItem.sectionKey, anchorItem.graphObject)) != -1) {
                this.listView.setSelectionFromTop(newPositionOfItem, top);
            }
            if (dataChanged && this.onDataChangedListener != null) {
                this.onDataChangedListener.onDataChanged(this);
            }
        }
    }

    private void reprioritizeDownloads() {
        int lastVisibleItem = this.listView.getLastVisiblePosition();
        if (lastVisibleItem >= 0) {
            int firstVisibleItem = this.listView.getFirstVisiblePosition();
            this.adapter.prioritizeViewRange(firstVisibleItem, lastVisibleItem, 5);
        }
    }

    abstract class PickerFragmentAdapter<U extends GraphObject>
    extends GraphObjectAdapter<T> {
        public PickerFragmentAdapter(Context context) {
            super(context);
        }

        @Override
        boolean isGraphObjectSelected(String graphObjectId) {
            return PickerFragment.this.selectionStrategy.isSelected(graphObjectId);
        }

        @Override
        void updateCheckboxState(CheckBox checkBox, boolean graphObjectSelected) {
            checkBox.setChecked(graphObjectSelected);
            int visible = graphObjectSelected || PickerFragment.this.selectionStrategy.shouldShowCheckBoxIfUnselected() ? 0 : 8;
            checkBox.setVisibility(visible);
        }
    }

    class MultiSelectionStrategy
    extends SelectionStrategy {
        private Set<String> selectedIds;

        MultiSelectionStrategy() {
            this.selectedIds = new HashSet<String>();
        }

        @Override
        public Collection<String> getSelectedIds() {
            return this.selectedIds;
        }

        @Override
        boolean isSelected(String id2) {
            return id2 != null && this.selectedIds.contains(id2);
        }

        @Override
        void toggleSelection(String id2) {
            if (id2 != null) {
                if (this.selectedIds.contains(id2)) {
                    this.selectedIds.remove(id2);
                } else {
                    this.selectedIds.add(id2);
                }
            }
        }

        @Override
        void saveSelectionToBundle(Bundle outBundle, String key) {
            if (!this.selectedIds.isEmpty()) {
                String ids = TextUtils.join((CharSequence)",", this.selectedIds);
                outBundle.putString(key, ids);
            }
        }

        @Override
        void readSelectionFromBundle(Bundle inBundle, String key) {
            String ids;
            if (inBundle != null && (ids = inBundle.getString(key)) != null) {
                String[] splitIds = TextUtils.split((String)ids, (String)",");
                this.selectedIds.clear();
                Collections.addAll(this.selectedIds, splitIds);
            }
        }

        @Override
        public void clear() {
            this.selectedIds.clear();
        }

        @Override
        boolean isEmpty() {
            return this.selectedIds.isEmpty();
        }

        @Override
        boolean shouldShowCheckBoxIfUnselected() {
            return true;
        }
    }

    class SingleSelectionStrategy
    extends SelectionStrategy {
        private String selectedId;

        SingleSelectionStrategy() {
        }

        @Override
        public Collection<String> getSelectedIds() {
            return Arrays.asList(this.selectedId);
        }

        @Override
        boolean isSelected(String id2) {
            return this.selectedId != null && id2 != null && this.selectedId.equals(id2);
        }

        @Override
        void toggleSelection(String id2) {
            this.selectedId = this.selectedId != null && this.selectedId.equals(id2) ? null : id2;
        }

        @Override
        void saveSelectionToBundle(Bundle outBundle, String key) {
            if (!TextUtils.isEmpty((CharSequence)this.selectedId)) {
                outBundle.putString(key, this.selectedId);
            }
        }

        @Override
        void readSelectionFromBundle(Bundle inBundle, String key) {
            if (inBundle != null) {
                this.selectedId = inBundle.getString(key);
            }
        }

        @Override
        public void clear() {
            this.selectedId = null;
        }

        @Override
        boolean isEmpty() {
            return this.selectedId == null;
        }

        @Override
        boolean shouldShowCheckBoxIfUnselected() {
            return false;
        }
    }

    abstract class SelectionStrategy {
        SelectionStrategy() {
        }

        abstract boolean isSelected(String var1);

        abstract void toggleSelection(String var1);

        abstract Collection<String> getSelectedIds();

        abstract void clear();

        abstract boolean isEmpty();

        abstract boolean shouldShowCheckBoxIfUnselected();

        abstract void saveSelectionToBundle(Bundle var1, String var2);

        abstract void readSelectionFromBundle(Bundle var1, String var2);
    }

    abstract class LoadingStrategy {
        protected static final int CACHED_RESULT_REFRESH_DELAY = 2000;
        protected GraphObjectPagingLoader<T> loader;
        protected GraphObjectAdapter<T> adapter;

        LoadingStrategy() {
        }

        public void attach(GraphObjectAdapter<T> adapter) {
            this.loader = (GraphObjectPagingLoader)PickerFragment.this.getLoaderManager().initLoader(0, null, new LoaderManager.LoaderCallbacks<SimpleGraphObjectCursor<T>>(){

                public Loader<SimpleGraphObjectCursor<T>> onCreateLoader(int id2, Bundle args) {
                    return LoadingStrategy.this.onCreateLoader();
                }

                public void onLoadFinished(Loader<SimpleGraphObjectCursor<T>> loader, SimpleGraphObjectCursor<T> data) {
                    if (loader != LoadingStrategy.this.loader) {
                        throw new FacebookException("Received callback for unknown loader.");
                    }
                    LoadingStrategy.this.onLoadFinished((GraphObjectPagingLoader)loader, data);
                }

                public void onLoaderReset(Loader<SimpleGraphObjectCursor<T>> loader) {
                    if (loader != LoadingStrategy.this.loader) {
                        throw new FacebookException("Received callback for unknown loader.");
                    }
                    LoadingStrategy.this.onLoadReset((GraphObjectPagingLoader)loader);
                }
            });
            this.loader.setOnErrorListener(new GraphObjectPagingLoader.OnErrorListener(){

                @Override
                public void onError(FacebookException error, GraphObjectPagingLoader<?> loader) {
                    PickerFragment.this.hideActivityCircle();
                    if (PickerFragment.this.onErrorListener != null) {
                        PickerFragment.this.onErrorListener.onError(PickerFragment.this, error);
                    }
                }
            });
            this.adapter = adapter;
            this.adapter.changeCursor(this.loader.getCursor());
            this.adapter.setOnErrorListener(new GraphObjectAdapter.OnErrorListener(){

                @Override
                public void onError(GraphObjectAdapter<?> adapter, FacebookException error) {
                    if (PickerFragment.this.onErrorListener != null) {
                        PickerFragment.this.onErrorListener.onError(PickerFragment.this, error);
                    }
                }
            });
        }

        public void detach() {
            this.adapter.setDataNeededListener(null);
            this.adapter.setOnErrorListener(null);
            this.loader.setOnErrorListener(null);
            this.loader = null;
            this.adapter = null;
        }

        public void clearResults() {
            if (this.loader != null) {
                this.loader.clearResults();
            }
        }

        public void startLoading(Request request) {
            if (this.loader != null) {
                this.loader.startLoading(request, this.canSkipRoundTripIfCached());
                this.onStartLoading(this.loader, request);
            }
        }

        public boolean isDataPresentOrLoading() {
            return !this.adapter.isEmpty() || this.loader.isLoading();
        }

        protected GraphObjectPagingLoader<T> onCreateLoader() {
            return new GraphObjectPagingLoader((Context)PickerFragment.this.getActivity(), PickerFragment.this.graphObjectClass);
        }

        protected void onStartLoading(GraphObjectPagingLoader<T> loader, Request request) {
            PickerFragment.this.displayActivityCircle();
        }

        protected void onLoadReset(GraphObjectPagingLoader<T> loader) {
            this.adapter.changeCursor(null);
        }

        protected void onLoadFinished(GraphObjectPagingLoader<T> loader, SimpleGraphObjectCursor<T> data) {
            PickerFragment.this.updateAdapter(data);
        }

        protected boolean canSkipRoundTripIfCached() {
            return true;
        }
    }

    public static interface GraphObjectFilter<T> {
        public boolean includeItem(T var1);
    }

    public static interface OnDoneButtonClickedListener {
        public void onDoneButtonClicked(PickerFragment<?> var1);
    }

    public static interface OnSelectionChangedListener {
        public void onSelectionChanged(PickerFragment<?> var1);
    }

    public static interface OnDataChangedListener {
        public void onDataChanged(PickerFragment<?> var1);
    }

    public static interface OnErrorListener {
        public void onError(PickerFragment<?> var1, FacebookException var2);
    }
}

