/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cloud.connectors.kafka.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class AdditionalPropertiesParser {
    private static final Logger LOG = Logger.getLogger(AdditionalPropertiesParser.class.getName());
    private static final String LIST_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final char ESCAPE_CHARACTER = '\'';
    private String propertiesString;

    public AdditionalPropertiesParser(String propertiesString) {
        this.propertiesString = propertiesString;
    }

    private static String[] split(String propertiesString, String separator) {
        ArrayList<String> properties = new ArrayList<String>();
        boolean insideComplexValue = false;
        StringBuilder part = new StringBuilder();
        for (int i = 0; i < propertiesString.length(); ++i) {
            part.append(propertiesString.charAt(i));
            if (propertiesString.charAt(i) == '\'') {
                boolean bl = insideComplexValue = !insideComplexValue;
            }
            if (!part.substring(part.length() - separator.length()).equals(separator) || insideComplexValue) continue;
            properties.add(part.substring(0, part.length() - separator.length()));
            part.setLength(0);
        }
        if (part.length() > 0) {
            properties.add(part.toString());
        }
        return properties.toArray(new String[0]);
    }

    private static String correctSingleQuotes(String val) {
        String cleaned = val.replace("''", "'");
        if (cleaned.charAt(0) == '\'') {
            cleaned = cleaned.substring(1);
        }
        if (cleaned.charAt(cleaned.length() - 1) == '\'') {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return cleaned;
    }

    public static Properties merge(Properties base, Properties addtional) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)base);
        if (addtional != null) {
            for (String key : addtional.stringPropertyNames()) {
                properties.putIfAbsent(key, addtional.getProperty(key));
            }
        }
        return properties;
    }

    public Properties parse() {
        Properties properties = new Properties();
        if (this.propertiesString != null) {
            String[] splittedProperties;
            String lastKey = null;
            block4: for (String singleKeyValue : splittedProperties = AdditionalPropertiesParser.split(this.propertiesString, LIST_SEPARATOR)) {
                Object[] splittedKeyValue = AdditionalPropertiesParser.split(singleKeyValue, KEY_VALUE_SEPARATOR);
                switch (splittedKeyValue.length) {
                    case 2: {
                        String key;
                        lastKey = key = AdditionalPropertiesParser.correctSingleQuotes(splittedKeyValue[0].trim());
                        String value = AdditionalPropertiesParser.correctSingleQuotes(((String)splittedKeyValue[1]).trim());
                        String existingValue = properties.getProperty(key);
                        if (existingValue != null) {
                            properties.setProperty(key, existingValue + LIST_SEPARATOR + value);
                            continue block4;
                        }
                        properties.setProperty(key, value);
                        continue block4;
                    }
                    case 1: {
                        if (lastKey == null) continue block4;
                        String value = AdditionalPropertiesParser.correctSingleQuotes(splittedKeyValue[0].trim());
                        String existingValue = properties.getProperty(lastKey);
                        if (existingValue != null) {
                            properties.setProperty(lastKey, existingValue + LIST_SEPARATOR + value);
                            continue block4;
                        }
                        properties.setProperty(lastKey, value);
                        continue block4;
                    }
                    default: {
                        LOG.warning("Found illegal properties " + Arrays.toString(splittedKeyValue));
                    }
                }
            }
        }
        return properties;
    }
}

