/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cloud.connectors.kafka.outbound;

import fish.payara.cloud.connectors.kafka.api.KafkaConnection;
import fish.payara.cloud.connectors.kafka.api.KafkaConnectionFactory;
import fish.payara.cloud.connectors.kafka.outbound.KafkaManagedConnectionFactory;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

class KafkaConnectionFactoryImpl
implements KafkaConnectionFactory,
Serializable,
Referenceable {
    private KafkaManagedConnectionFactory cf;
    private ConnectionManager cm;
    private Reference reference;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KafkaConnectionFactoryImpl() {
    }

    public KafkaConnectionFactoryImpl(KafkaManagedConnectionFactory cf, ConnectionManager cm) {
        this.cf = cf;
        this.cm = cm;
        if (this.cm == null) {
            this.cm = new DummyConnectionManager();
        }
    }

    @Override
    public KafkaConnection createConnection() throws ResourceException {
        return (KafkaConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.cf, null);
    }

    @Override
    public KafkaConnection createConnection(ConnectionSpec spec) throws ResourceException {
        return (KafkaConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.cf, (ConnectionRequestInfo)spec);
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() throws NamingException {
        return this.reference;
    }

    private class DummyConnectionManager
    implements ConnectionManager {
        private DummyConnectionManager() {
        }

        public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
            return mcf.createManagedConnection(null, cxRequestInfo);
        }
    }
}

