/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cloud.connectors.kafka.outbound;

import fish.payara.cloud.connectors.kafka.api.KafkaConnection;
import fish.payara.cloud.connectors.kafka.api.KafkaConnectionFactory;
import fish.payara.cloud.connectors.kafka.outbound.KafkaConnectionFactoryImpl;
import fish.payara.cloud.connectors.kafka.outbound.KafkaConnectionImpl;
import fish.payara.cloud.connectors.kafka.outbound.KafkaManagedConnection;
import fish.payara.cloud.connectors.kafka.tools.AdditionalPropertiesParser;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import org.apache.kafka.clients.producer.KafkaProducer;

@ConnectionDefinition(connection=KafkaConnection.class, connectionFactory=KafkaConnectionFactory.class, connectionFactoryImpl=KafkaConnectionFactoryImpl.class, connectionImpl=KafkaConnectionImpl.class)
public class KafkaManagedConnectionFactory
implements ManagedConnectionFactory,
TransactionSupport,
Serializable {
    private final Properties producerProperties = new Properties();
    private AdditionalPropertiesParser additionalPropertiesParser;
    @ConfigProperty(defaultValue="localhost:9092", description={"Kafka Servers to Connect to"}, type=String.class)
    private String bootstrapServersConfig;
    @ConfigProperty(defaultValue="KafkaJCAClient", description={"Client ID of the Producer"}, type=String.class)
    private String clientId;
    @ConfigProperty(defaultValue="org.apache.kafka.common.serialization.StringSerializer", type=String.class, description={"Serializer class for key"})
    private String valueSerializer;
    @ConfigProperty(defaultValue="org.apache.kafka.common.serialization.StringSerializer", type=String.class, description={"Serializer class for value"})
    private String keySerializer;
    @ConfigProperty(type=Long.class, defaultValue="33554432", description={"The total bytes the producer can use to buffer messages"})
    private Long bufferMemory;
    @ConfigProperty(type=String.class, description={"The number of acks the producer requires"}, defaultValue="1")
    private String acks;
    @ConfigProperty(type=Integer.class, description={"The number of retries if there is a transient error"}, defaultValue="0")
    private Integer retries;
    @ConfigProperty(type=Long.class, description={"The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition"}, defaultValue="16384")
    private Long batchSize;
    @ConfigProperty(type=Long.class, defaultValue="0", description={"The producer groups together any records that arrive in between request transmissions into a single batched request. "})
    private Long lingerMS;
    @ConfigProperty(type=Long.class, defaultValue="60000", description={"How long can send block "})
    private Long maxBlockMS;
    @ConfigProperty(type=Long.class, defaultValue="1048576", description={"Maximum size of request (bytes)"})
    private Long maxRequestSize;
    @ConfigProperty(type=Integer.class, defaultValue="32768", description={"Receive Buffer (bytes)"})
    private Integer receiveBufferBytes;
    @ConfigProperty(type=Integer.class, defaultValue="30000", description={"Request Timeout (ms)"})
    private Integer requestTimeout;
    @ConfigProperty(type=String.class, description={"Compression type of data sent"}, defaultValue="none")
    private String compression;
    @ConfigProperty(type=Long.class, description={"Close Idle Kafka Connections"}, defaultValue="540000")
    private Long connectionsMaxIdle;
    @ConfigProperty(type=Integer.class, defaultValue="5", description={"Maximum unacknowledged requests to send before blocking"})
    private Integer maxInflightConnections;
    @ConfigProperty(type=Long.class, description={"Period of time before a refresh of Metadata (ms)"}, defaultValue="300000")
    private Long metadataMaxAge;
    @ConfigProperty(type=Long.class, description={"The amount of time to wait before attempting a retry (ms)"}, defaultValue="100")
    private Long retryBackoff;
    @ConfigProperty(type=Long.class, description={"The amount of time to wait before attempting a reconnection (ms)"}, defaultValue="100")
    private Long reconnectBackoff;
    @ConfigProperty(type=String.class, description={"Additional properties to be passed to the KafkaConnection."})
    private String additionalProperties;
    private transient PrintWriter writer;
    private transient KafkaProducer producer;

    public String getBootstrapServersConfig() {
        return this.bootstrapServersConfig;
    }

    public void setBootstrapServersConfig(String bootstrapServersConfig) {
        this.bootstrapServersConfig = bootstrapServersConfig;
        this.producerProperties.setProperty("bootstrap.servers", bootstrapServersConfig);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        this.producerProperties.setProperty("client.id", clientId);
    }

    public String getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(String valueDeserializer) {
        this.valueSerializer = valueDeserializer;
        this.producerProperties.setProperty("value.serializer", valueDeserializer);
    }

    public String getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(String keyDeserializer) {
        this.keySerializer = keyDeserializer;
        this.producerProperties.setProperty("key.serializer", keyDeserializer);
    }

    public Long getBufferMemory() {
        return this.bufferMemory;
    }

    public void setBufferMemory(Long bufferMemory) {
        this.bufferMemory = bufferMemory;
        this.producerProperties.setProperty("buffer.memory", Long.toString(bufferMemory));
    }

    public String getAcks() {
        return this.acks;
    }

    public void setAcks(String acks) {
        this.acks = acks;
        this.producerProperties.setProperty("acks", acks);
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
        this.producerProperties.setProperty("retries", Long.toString(retries.intValue()));
    }

    public Long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Long batchSize) {
        this.batchSize = batchSize;
        this.producerProperties.setProperty("batch.size", Long.toString(batchSize));
    }

    public Long getLingerMS() {
        return this.lingerMS;
    }

    public void setLingerMS(Long lingerMS) {
        this.lingerMS = lingerMS;
        this.producerProperties.setProperty("linger.ms", Long.toString(lingerMS));
    }

    public Properties getProducerProperties() {
        return this.producerProperties;
    }

    public Long getMaxBlockMS() {
        return this.maxBlockMS;
    }

    public void setMaxBlockMS(Long maxBlockMS) {
        this.maxBlockMS = maxBlockMS;
        this.producerProperties.setProperty("max.block.ms", Long.toString(maxBlockMS));
    }

    public Long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(Long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        this.producerProperties.setProperty("max.request.size", Long.toString(maxRequestSize));
    }

    public Integer getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReceiveBufferBytes(Integer receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
        this.producerProperties.setProperty("receive.buffer.bytes", Integer.toString(receiveBufferBytes));
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.producerProperties.setProperty("request.timeout.ms", Integer.toString(requestTimeout));
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
        this.producerProperties.setProperty("compression.type", compression);
    }

    public Long getConnectionsMaxIdle() {
        return this.connectionsMaxIdle;
    }

    public void setConnectionsMaxIdle(Long maxIdle) {
        this.connectionsMaxIdle = maxIdle;
        this.producerProperties.setProperty("connections.max.idle.ms", Long.toString(maxIdle));
    }

    public Integer getMaxInflightConnections() {
        return this.maxInflightConnections;
    }

    public void setMaxInflightConnections(Integer maxInflightConnections) {
        this.maxInflightConnections = maxInflightConnections;
        this.producerProperties.setProperty("max.in.flight.requests.per.connection", Integer.toString(maxInflightConnections));
    }

    public Long getMetadataMaxAge() {
        return this.metadataMaxAge;
    }

    public void setMetadataMaxAge(Long metadataMaxAge) {
        this.metadataMaxAge = metadataMaxAge;
        this.producerProperties.setProperty("metadata.max.age.ms", Long.toString(metadataMaxAge));
    }

    public Long getRetryBackoff() {
        return this.retryBackoff;
    }

    public void setRetryBackoff(Long retryBackoff) {
        this.retryBackoff = retryBackoff;
        this.producerProperties.setProperty("retry.backoff.ms", Long.toString(retryBackoff));
    }

    public Long getReconnectBackoff() {
        return this.reconnectBackoff;
    }

    public void setReconnectBackoff(Long reconnectBackoff) {
        this.reconnectBackoff = reconnectBackoff;
        this.producerProperties.setProperty("reconnect.backoff.ms", Long.toString(reconnectBackoff));
    }

    public String getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(String additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.additionalPropertiesParser = new AdditionalPropertiesParser(additionalProperties);
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        Properties properties;
        Properties properties2 = properties = this.additionalPropertiesParser == null ? this.producerProperties : AdditionalPropertiesParser.merge(this.producerProperties, this.additionalPropertiesParser.parse());
        if (this.producer == null) {
            this.producer = new KafkaProducer(properties);
        }
        return new KafkaConnectionFactoryImpl(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        Properties properties;
        Properties properties2 = properties = this.additionalPropertiesParser == null ? this.producerProperties : AdditionalPropertiesParser.merge(this.producerProperties, this.additionalPropertiesParser.parse());
        if (this.producer == null) {
            this.producer = new KafkaProducer(properties);
        }
        return new KafkaConnectionFactoryImpl(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Properties properties = this.additionalPropertiesParser == null ? this.producerProperties : AdditionalPropertiesParser.merge(this.producerProperties, this.additionalPropertiesParser.parse());
        return new KafkaManagedConnection(this.producer);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return (ManagedConnection)connectionSet.toArray()[0];
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.writer = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.writer;
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return TransactionSupport.TransactionSupportLevel.NoTransaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaManagedConnectionFactory that = (KafkaManagedConnectionFactory)o;
        return Objects.equals(this.producerProperties, that.producerProperties) && Objects.equals(this.bootstrapServersConfig, that.bootstrapServersConfig) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.valueSerializer, that.valueSerializer) && Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.bufferMemory, that.bufferMemory) && Objects.equals(this.acks, that.acks) && Objects.equals(this.retries, that.retries) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.lingerMS, that.lingerMS) && Objects.equals(this.maxBlockMS, that.maxBlockMS) && Objects.equals(this.maxRequestSize, that.maxRequestSize) && Objects.equals(this.receiveBufferBytes, that.receiveBufferBytes) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.compression, that.compression) && Objects.equals(this.connectionsMaxIdle, that.connectionsMaxIdle) && Objects.equals(this.maxInflightConnections, that.maxInflightConnections) && Objects.equals(this.metadataMaxAge, that.metadataMaxAge) && Objects.equals(this.retryBackoff, that.retryBackoff) && Objects.equals(this.reconnectBackoff, that.reconnectBackoff) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.producerProperties, this.bootstrapServersConfig, this.clientId, this.valueSerializer, this.keySerializer, this.bufferMemory, this.acks, this.retries, this.batchSize, this.lingerMS, this.maxBlockMS, this.maxRequestSize, this.receiveBufferBytes, this.requestTimeout, this.compression, this.connectionsMaxIdle, this.maxInflightConnections, this.metadataMaxAge, this.retryBackoff, this.reconnectBackoff, this.additionalProperties);
    }
}

