/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.widgets;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import eu.livotov.labs.android.robotools.R;
import eu.livotov.labs.android.robotools.hardware.RTDevice;

public class RTMaterialProgressView
extends View {
    private static final int MAX_LEVEL = 10000;
    private static final int ANIMATION_RESOLUTION = 200;
    private static final int SMALL_SIZE = 0;
    private static final int NORMAL_SIZE = 1;
    private static final int LARGE_SIZE = 2;
    private int mMinWidth;
    private int mMaxWidth;
    private int mMinHeight;
    private int mMaxHeight;
    private int mColor;
    private int mSize;
    private boolean mIndeterminate;
    private int mBorderWidth;
    private RectF arcRectF;
    private int mMax;
    private int mProgress;
    private int mDuration;
    private boolean mHasAnimation;
    private boolean mAttached;
    private long mLastDrawTime;
    private IndeterminateProgressDrawable mIndeterminateProgressDrawable;
    private DeterminateProgressDrawable mDeterminateProgressDrawable;

    public RTMaterialProgressView(Context context) {
        this(context, null);
    }

    public RTMaterialProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RTMaterialProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RTMaterialProgressView);
        this.mColor = attributes.getColor(R.styleable.RTMaterialProgressView_rtm_progress_color, this.getResources().getColor(17170450));
        this.mSize = attributes.getInt(R.styleable.RTMaterialProgressView_rtm_progress_size, 0);
        this.mIndeterminate = attributes.getBoolean(R.styleable.RTMaterialProgressView_rtm_progress_indeterminate, true);
        this.mBorderWidth = attributes.getDimensionPixelSize(R.styleable.RTMaterialProgressView_rtm_progress_border_width, (int)RTDevice.px2dp(this.getContext(), 3.0f));
        this.mDuration = attributes.getInteger(R.styleable.RTMaterialProgressView_rtm_progress_duration, 200);
        this.mMax = attributes.getInteger(R.styleable.RTMaterialProgressView_rtm_progress_max, 100);
        attributes.recycle();
        if (this.mIndeterminate) {
            this.mIndeterminateProgressDrawable = new IndeterminateProgressDrawable(this.mColor, this.mBorderWidth);
            this.mIndeterminateProgressDrawable.setCallback((Drawable.Callback)this);
        } else {
            this.mDeterminateProgressDrawable = new DeterminateProgressDrawable(this.mColor, this.mBorderWidth, 0);
            this.mDeterminateProgressDrawable.setCallback((Drawable.Callback)this);
        }
    }

    public void setColor(int color2) {
        this.mColor = color2;
        this.invalidate();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.mIndeterminate = indeterminate;
        this.invalidate();
    }

    public synchronized int getProgress() {
        return this.mIndeterminate ? 0 : this.mProgress;
    }

    public void setProgress(int progress) {
        if (this.mIndeterminate || progress > this.mMax || progress < 0) {
            return;
        }
        this.mProgress = progress;
        this.invalidate();
    }

    public synchronized int getMax() {
        return this.mMax;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            max = 0;
        }
        if (max != this.mMax) {
            this.mMax = max;
            this.postInvalidate();
            if (this.mProgress > max) {
                this.mProgress = max;
            }
        }
    }

    private RectF getArcRectF() {
        if (this.arcRectF == null) {
            int size = Math.min(this.getWidth() - this.mBorderWidth * 2, this.getHeight() - this.mBorderWidth * 2);
            this.arcRectF = new RectF();
            this.arcRectF.left = (this.getWidth() - size) / 2;
            this.arcRectF.top = (this.getHeight() - size) / 2;
            this.arcRectF.right = this.getWidth() - (this.getWidth() - size) / 2;
            this.arcRectF.bottom = this.getHeight() - (this.getHeight() - size) / 2;
        }
        return this.arcRectF;
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mIndeterminate) {
            if (visibility == 0) {
                this.mIndeterminateProgressDrawable.start();
            } else {
                this.mIndeterminateProgressDrawable.stop();
            }
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        if (this.mIndeterminate) {
            this.mIndeterminateProgressDrawable.setBounds(0, 0, width, height);
        } else {
            this.mDeterminateProgressDrawable.setBounds(0, 0, width, height);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startAnimation();
        }
        this.mAttached = true;
    }

    public void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        this.mIndeterminateProgressDrawable.start();
    }

    protected void onDetachedFromWindow() {
        if (this.mIndeterminate) {
            this.stopAnimation();
        }
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    public void stopAnimation() {
        this.mIndeterminateProgressDrawable.stop();
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.mIndeterminate) {
            this.mIndeterminateProgressDrawable.draw(canvas);
        } else {
            this.mDeterminateProgressDrawable.draw(canvas);
        }
    }

    protected boolean verifyDrawable(Drawable drawable) {
        if (this.mIndeterminate) {
            return drawable == this.mIndeterminateProgressDrawable || super.verifyDrawable(drawable);
        }
        return drawable == this.mDeterminateProgressDrawable || super.verifyDrawable(drawable);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthSpecMode == Integer.MIN_VALUE && heightSpecMode == Integer.MIN_VALUE) {
            int size = 0;
            switch (this.mSize) {
                case 0: {
                    size = this.getResources().getDimensionPixelSize(R.dimen.rtm_progress_small_size);
                    break;
                }
                case 1: {
                    size = this.getResources().getDimensionPixelSize(R.dimen.rtm_progress_normal_size);
                    break;
                }
                case 2: {
                    size = this.getResources().getDimensionPixelSize(R.dimen.rtm_progress_large_size);
                }
            }
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private class IndeterminateProgressDrawable
    extends Drawable
    implements Animatable {
        private static final int ANGLE_ANIMATOR_DURATION = 2000;
        private static final int SWEEP_ANIMATOR_DURATION = 600;
        private static final int MIN_SWEEP_ANGLE = 30;
        private final Interpolator ANGLE_INTERPOLATOR = new LinearInterpolator();
        private final Interpolator SWEEP_INTERPOLATOR = new DecelerateInterpolator();
        private final RectF mDrawableBounds = new RectF();
        private ObjectAnimator mObjectAnimatorSweep;
        private ObjectAnimator mObjectAnimatorAngle;
        private boolean mModeAppearing;
        private Paint mPaint;
        private float mCurrentGlobalAngleOffset;
        private float mCurrentGlobalAngle;
        private float mCurrentSweepAngle;
        private float mBorderWidth;
        private boolean mRunning;
        private Property<IndeterminateProgressDrawable, Float> mAngleProperty = new Property<IndeterminateProgressDrawable, Float>(Float.class, "angle"){

            public void set(IndeterminateProgressDrawable object, Float value) {
                object.setCurrentGlobalAngle(value.floatValue());
            }

            public Float get(IndeterminateProgressDrawable object) {
                return Float.valueOf(object.getCurrentGlobalAngle());
            }
        };
        private Property<IndeterminateProgressDrawable, Float> mSweepProperty = new Property<IndeterminateProgressDrawable, Float>(Float.class, "arc"){

            public Float get(IndeterminateProgressDrawable object) {
                return Float.valueOf(object.getCurrentSweepAngle());
            }

            public void set(IndeterminateProgressDrawable object, Float value) {
                object.setCurrentSweepAngle(value.floatValue());
            }
        };

        public IndeterminateProgressDrawable(int color2, float borderWidth) {
            this.mBorderWidth = borderWidth;
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(borderWidth);
            this.mPaint.setColor(color2);
            this.setupAnimations();
        }

        public void draw(Canvas canvas) {
            float startAngle = this.mCurrentGlobalAngle - this.mCurrentGlobalAngleOffset;
            float sweepAngle = this.mCurrentSweepAngle;
            if (!this.mModeAppearing) {
                startAngle += sweepAngle;
                sweepAngle = 360.0f - sweepAngle - 30.0f;
            } else {
                sweepAngle += 30.0f;
            }
            canvas.drawArc(this.mDrawableBounds, startAngle, sweepAngle, false, this.mPaint);
        }

        private void setupAnimations() {
            this.mObjectAnimatorAngle = ObjectAnimator.ofFloat((Object)((Object)this), this.mAngleProperty, (float[])new float[]{360.0f});
            this.mObjectAnimatorAngle.setInterpolator((TimeInterpolator)this.ANGLE_INTERPOLATOR);
            this.mObjectAnimatorAngle.setDuration(2000L);
            this.mObjectAnimatorAngle.setRepeatMode(1);
            this.mObjectAnimatorAngle.setRepeatCount(-1);
            this.mObjectAnimatorSweep = ObjectAnimator.ofFloat((Object)((Object)this), this.mSweepProperty, (float[])new float[]{300.0f});
            this.mObjectAnimatorSweep.setInterpolator((TimeInterpolator)this.SWEEP_INTERPOLATOR);
            this.mObjectAnimatorSweep.setDuration(600L);
            this.mObjectAnimatorSweep.setRepeatMode(1);
            this.mObjectAnimatorSweep.setRepeatCount(-1);
            this.mObjectAnimatorSweep.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                    IndeterminateProgressDrawable.this.toggleAppearingMode();
                }
            });
        }

        private void toggleAppearingMode() {
            boolean bl = this.mModeAppearing = !this.mModeAppearing;
            if (this.mModeAppearing) {
                this.mCurrentGlobalAngleOffset = (this.mCurrentGlobalAngleOffset + 60.0f) % 360.0f;
            }
        }

        public void setAlpha(int alpha) {
            this.mPaint.setAlpha(alpha);
        }

        public void start() {
            if (this.isRunning()) {
                return;
            }
            this.mRunning = true;
            this.mObjectAnimatorAngle.start();
            this.mObjectAnimatorSweep.start();
            this.invalidateSelf();
        }

        public void stop() {
            if (!this.isRunning()) {
                return;
            }
            this.mRunning = false;
            this.mObjectAnimatorAngle.cancel();
            this.mObjectAnimatorSweep.cancel();
            this.invalidateSelf();
        }

        public void setColorFilter(ColorFilter cf) {
            this.mPaint.setColorFilter(cf);
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public float getCurrentGlobalAngle() {
            return this.mCurrentGlobalAngle;
        }

        public int getOpacity() {
            return -2;
        }

        public void setCurrentGlobalAngle(float currentGlobalAngle) {
            this.mCurrentGlobalAngle = currentGlobalAngle;
            this.invalidateSelf();
        }

        public float getCurrentSweepAngle() {
            return this.mCurrentSweepAngle;
        }

        public void setCurrentSweepAngle(float currentSweepAngle) {
            this.mCurrentSweepAngle = currentSweepAngle;
            this.invalidateSelf();
        }

        protected void onBoundsChange(Rect bounds) {
            super.onBoundsChange(bounds);
            this.mDrawableBounds.left = (float)bounds.left + this.mBorderWidth / 2.0f + 0.5f;
            this.mDrawableBounds.right = (float)bounds.right - this.mBorderWidth / 2.0f - 0.5f;
            this.mDrawableBounds.top = (float)bounds.top + this.mBorderWidth / 2.0f + 0.5f;
            this.mDrawableBounds.bottom = (float)bounds.bottom - this.mBorderWidth / 2.0f - 0.5f;
        }
    }

    private class DeterminateProgressDrawable
    extends Drawable {
        private final RectF mDrawableBounds = new RectF();
        private Paint mPaint = new Paint();
        private float mBorderWidth;
        private float mEndAngle;

        public DeterminateProgressDrawable(int color2, int borderWidth, int angle) {
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)borderWidth);
            this.mPaint.setColor(color2);
            this.mBorderWidth = borderWidth;
            this.mEndAngle = angle;
        }

        public void setAngle(float angle) {
            this.mEndAngle = angle;
        }

        public void draw(Canvas canvas) {
            canvas.drawArc(this.mDrawableBounds, -90.0f, 20.0f, false, this.mPaint);
        }

        public void setAlpha(int alpha) {
            this.mPaint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mPaint.setColorFilter(colorFilter);
        }

        public int getOpacity() {
            return -2;
        }

        protected void onBoundsChange(Rect bounds) {
            super.onBoundsChange(bounds);
            this.mDrawableBounds.left = (float)bounds.left + this.mBorderWidth / 2.0f + 0.5f;
            this.mDrawableBounds.right = (float)bounds.right - this.mBorderWidth / 2.0f - 0.5f;
            this.mDrawableBounds.top = (float)bounds.top + this.mBorderWidth / 2.0f + 0.5f;
            this.mDrawableBounds.bottom = (float)bounds.bottom - this.mBorderWidth / 2.0f - 0.5f;
        }
    }
}

