/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.settings;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import eu.livotov.labs.android.robotools.crypt.RTDataCryptEngine;
import eu.livotov.labs.android.robotools.settings.RTPrefs;
import eu.livotov.labs.android.robotools.text.RTBase64;

public class RTSecurePrefs {
    private static RTSecurePrefs defaultPreferences;
    protected RTPrefs innerPrefs;
    private RTDataCryptEngine cryptEngine;

    public RTSecurePrefs(Context ctx) {
        this.innerPrefs = new RTPrefs(ctx, "defaultsecure", false);
        this.init(ctx, false);
    }

    public RTSecurePrefs(Context ctx, String preferenceStorageName) {
        this.innerPrefs = new RTPrefs(ctx, preferenceStorageName, false);
        this.init(ctx, false);
    }

    public RTSecurePrefs(Context ctx, String preferenceStorageName, boolean transferable) {
        this.innerPrefs = new RTPrefs(ctx, preferenceStorageName, true);
        this.init(ctx, transferable);
    }

    private void init(Context ctx, boolean transferable) {
        this.cryptEngine = new RTDataCryptEngine(ctx, transferable);
    }

    public static synchronized RTSecurePrefs getDefault(Context ctx) {
        if (defaultPreferences == null) {
            defaultPreferences = new RTSecurePrefs(ctx);
        }
        return defaultPreferences;
    }

    public boolean contains(@StringRes int key) {
        return this.contains(this.innerPrefs.ctx.getString(key));
    }

    public boolean contains(String key) {
        return !TextUtils.isEmpty((CharSequence)this.innerPrefs.getString(key, null));
    }

    public String getString(@StringRes int key, String defaultValue) {
        return this.getString(this.innerPrefs.ctx.getString(key), defaultValue);
    }

    public synchronized String getString(@NonNull String key, String defaultValue) {
        try {
            String encryptedValue = this.innerPrefs.getString(key, defaultValue);
            if (TextUtils.isEmpty((CharSequence)encryptedValue) || encryptedValue.equalsIgnoreCase(defaultValue)) {
                return encryptedValue;
            }
            return this.cryptEngine.decryptString(encryptedValue);
        }
        catch (Throwable err) {
            this.reset();
            return null;
        }
    }

    public int getInt(@StringRes int key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public int getInt(@NonNull String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public void setInt(@StringRes int key, int value) {
        this.setString(key, "" + value);
    }

    public void setString(@StringRes int key, String value) {
        this.setString(this.innerPrefs.ctx.getString(key), value);
    }

    public synchronized void setString(@NonNull String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            this.innerPrefs.remove(key);
        } else {
            try {
                this.innerPrefs.setString(key, this.cryptEngine.encryptString(value));
            }
            catch (Throwable throwable) {
                this.reset();
            }
        }
    }

    public void reset() {
        this.innerPrefs.clear();
        this.cryptEngine.reset();
    }

    public void setInt(@NonNull String key, int value) {
        this.setString(key, "" + value);
    }

    public long getLong(@StringRes int key, long defaultValue) {
        try {
            return Long.parseLong(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public long getLong(@NonNull String key, long defaultValue) {
        try {
            return Long.parseLong(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public void setIntArray(@StringRes int key, int[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setIntArray(@NonNull String key, int[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setLongArray(@StringRes int key, long[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setLongArray(@NonNull String key, long[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setByteArray(@StringRes int key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    public void setByteArray(@NonNull String key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    public int[] getIntArray(@StringRes int key) {
        return RTPrefs.stringToIntegerArray(this.getString(key, ""));
    }

    public int[] getIntArray(@NonNull String key) {
        return RTPrefs.stringToIntegerArray(this.getString(key, ""));
    }

    public long[] getLongArray(@StringRes int key) {
        return RTPrefs.stringToLongArray(this.getString(key, ""));
    }

    public long[] getLongArray(@NonNull String key) {
        return RTPrefs.stringToLongArray(this.getString(key, ""));
    }

    public byte[] getByteArray(@StringRes int key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    public byte[] getByteArray(@NonNull String key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    public void setLong(@StringRes int key, long value) {
        this.setString(key, "" + value);
    }

    public void setLong(@NonNull String key, long value) {
        this.setString(key, "" + value);
    }

    public void setDouble(@StringRes int key, double value) {
        this.setString(key, "" + value);
    }

    public void setDouble(String key, double value) {
        this.setString(key, "" + value);
    }

    public double getDouble(@StringRes int key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public double getDouble(@NonNull String key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public boolean getBoolean(@StringRes int key, boolean defaultValue) {
        try {
            return "1".equals(this.getString(key, defaultValue ? "1" : "0"));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        try {
            return "1".equals(this.getString(key, defaultValue ? "1" : "0"));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public void setBoolean(@StringRes int key, boolean value) {
        this.setString(key, value ? "1" : "0");
    }

    public void setBoolean(@NonNull String key, boolean value) {
        this.setString(key, value ? "1" : "0");
    }

    public <T> T getObject(Class<T> clazz, @StringRes int key, T defaultValue) {
        return this.getObject(clazz, this.innerPrefs.ctx.getString(key), defaultValue);
    }

    public <T> T getObject(Class<T> clazz, @NonNull String key, T defaultValue) {
        try {
            return (T)this.innerPrefs.gson.fromJson(this.getString(key, ""), clazz);
        }
        catch (Throwable ignored) {
            return defaultValue;
        }
    }

    public void setObject(@StringRes int key, Object object) {
        this.setObject(this.innerPrefs.ctx.getString(key), object);
    }

    public void setObject(@NonNull String key, Object object) {
        try {
            if (object != null) {
                this.setString(key, this.innerPrefs.gson.toJson(object));
            } else {
                this.innerPrefs.remove(key);
            }
        }
        catch (Throwable err) {
            throw new IllegalArgumentException("Cannot convert to JSON: " + object.toString(), err);
        }
    }
}

