/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;

public class RTNetwork {
    public static boolean isConnected(Context ctx) {
        ConnectivityManager connectivityManager = (ConnectivityManager)ctx.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 21) {
            Network[] networks = connectivityManager.getAllNetworks();
            if (null != networks) {
                for (Network network : networks) {
                    NetworkInfo networkInfo = connectivityManager.getNetworkInfo(network);
                    if (networkInfo == null || NetworkInfo.State.CONNECTED != networkInfo.getState()) continue;
                    return true;
                }
            }
        } else {
            NetworkInfo netInfo = connectivityManager.getActiveNetworkInfo();
            return netInfo != null && netInfo.isConnected();
        }
        return false;
    }

    public static boolean isConnectedToWiFi(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected() && netInfo.getType() == 1;
    }

    public static boolean isConnectedToCellular(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected() && netInfo.getType() != 1;
    }

    public static boolean isInRoaming(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.getType() != 1 && netInfo.isRoaming();
    }
}

