/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.hardware;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.TargetApi;
import android.app.KeyguardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.support.v4.hardware.fingerprint.FingerprintManagerCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import eu.livotov.labs.android.robotools.crypt.RTCryptUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class RTDevice {
    private static int cachedCoresCount = 0;

    private RTDevice() {
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static int getNavBarHeight(Context ctx) {
        int result = 0;
        boolean hasMenuKey = ViewConfiguration.get((Context)ctx).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        if (!hasMenuKey && !hasBackKey) {
            Resources resources = ctx.getResources();
            int orientation = ctx.getResources().getConfiguration().orientation;
            int resourceId = RTDevice.isTablet(ctx) ? resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android") : resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_width", "dimen", "android");
            if (resourceId > 0) {
                return ctx.getResources().getDimensionPixelSize(resourceId);
            }
        }
        return result;
    }

    public static float dp2px(Context ctx, float px) {
        return px / ctx.getResources().getDisplayMetrics().density;
    }

    public static float px2dp(Context ctx, float dp) {
        return dp * ctx.getResources().getDisplayMetrics().density;
    }

    public static boolean supportsCamera(Context ctx) {
        return ctx.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static boolean supportsTelephony(Context ctx) {
        return ctx.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    public static boolean supportsGps(Context ctx) {
        return ctx.getPackageManager().hasSystemFeature("android.hardware.location");
    }

    public static boolean supportsSms(Context ctx) {
        try {
            if (ctx.getPackageManager().hasSystemFeature("android.hardware.telephony")) {
                TelephonyManager telMgr = (TelephonyManager)ctx.getSystemService("phone");
                int simState = telMgr.getSimState();
                switch (simState) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return false;
                    }
                    case 5: {
                        return true;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable err) {
            err.printStackTrace();
            return false;
        }
    }

    public static synchronized int getCpuCoresCount() {
        if (cachedCoresCount == 0) {
            try {
                File dir = new File("/sys/devices/system/cpu/");
                File[] files = dir.listFiles(new CpuFilter());
                cachedCoresCount = files.length;
            }
            catch (Exception e) {
                Log.e((String)RTDevice.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
                cachedCoresCount = 1;
            }
        }
        return cachedCoresCount;
    }

    public static boolean isExternalStorageReady() {
        String state = Environment.getExternalStorageState();
        return !"removed".equals(state) && !"bad_removal".equals(state) && !"unmountable".equals(state) && !"unmounted".equals(state);
    }

    public static File getExternalStorage() {
        return RTDevice.getExternalStorage(null);
    }

    public static File getExternalStorage(String type) {
        File file = Environment.getExternalStoragePublicDirectory((String)type);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean isConnected(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }

    public static boolean isConnectedToWiFi(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected() && netInfo.getType() == 1;
    }

    public static boolean isConnectedToCellular(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected() && netInfo.getType() != 1;
    }

    public static boolean isInRoaming(Context ctx) {
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.getType() != 1 && netInfo.isRoaming();
    }

    public static CharSequence getOwnerEmail(Context context) {
        try {
            Account[] accounts = AccountManager.get((Context)context).getAccountsByType("com.google");
            return accounts != null && accounts.length > 0 ? accounts[0].name : null;
        }
        catch (Throwable err) {
            return null;
        }
    }

    public static String getDeviceUID(Context ctx) {
        StringBuffer id;
        block5: {
            id = new StringBuffer();
            if (ctx != null) {
                try {
                    String androidDeviceId = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id");
                    if (androidDeviceId == null) {
                        id.append(Build.FINGERPRINT);
                        break block5;
                    }
                    id.append(androidDeviceId);
                }
                catch (Throwable e) {
                    id.append(Build.FINGERPRINT);
                }
            } else {
                id.append(Build.FINGERPRINT);
            }
        }
        return RTCryptUtil.md5(id.toString());
    }

    public static boolean isBlackberryDevice() {
        if (!System.getProperty("os.name").equals("qnx")) {
            return Build.BRAND.toLowerCase().contains("blackberry");
        }
        return true;
    }

    public static boolean isFingerprintAvailable(Context context) {
        if (RTDevice.isMarshmallow()) {
            return RTDevice.getFingerprintManager(context).isHardwareDetected();
        }
        return false;
    }

    public static boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static FingerprintManagerCompat getFingerprintManager(Context context) {
        return FingerprintManagerCompat.from((Context)context);
    }

    @TargetApi(value=23)
    public static KeyguardManager getKeyguardManager(Context context) {
        return (KeyguardManager)context.getSystemService(KeyguardManager.class);
    }

    private static class CpuFilter
    implements FileFilter {
        private CpuFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return Pattern.matches("cpu[0-9]", pathname.getName());
        }
    }
}

