/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.graphics;

import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.ColorInt;

public class RTDrawables {
    public static Drawable makeRound(int diameter, @ColorInt int color) {
        ShapeDrawable round = new ShapeDrawable((Shape)new OvalShape());
        round.setIntrinsicHeight(diameter);
        round.setIntrinsicWidth(diameter);
        round.getPaint().setAntiAlias(true);
        round.getPaint().setColor(color);
        return round;
    }

    public static Drawable makeCircle(int diameter, int strokeWidth, @ColorInt int colorStroke) {
        ShapeDrawable round = new ShapeDrawable((Shape)new OvalShape());
        round.setIntrinsicHeight(diameter);
        round.setIntrinsicWidth(diameter);
        round.getPaint().setAntiAlias(true);
        round.getPaint().setStyle(Paint.Style.STROKE);
        round.getPaint().setStrokeWidth((float)strokeWidth);
        round.getPaint().setColor(colorStroke);
        return round;
    }

    public static Drawable makeRectOfWhiteColor(int w, int h) {
        return RTDrawables.makeRect(w, h, -1);
    }

    public static Drawable makeRect(int w, int h, @ColorInt int color) {
        ShapeDrawable rect = new ShapeDrawable((Shape)new RectShape());
        rect.setIntrinsicHeight(h);
        rect.setIntrinsicWidth(w);
        rect.getPaint().setAntiAlias(true);
        rect.getPaint().setColor(color);
        return rect;
    }

    public static Drawable makeSquare(int size, int color) {
        return RTDrawables.makeRect(size, size, color);
    }
}

