/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.crypt;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import eu.livotov.labs.android.robotools.R;
import eu.livotov.labs.android.robotools.crypt.RTCryptUtil;
import eu.livotov.labs.android.robotools.crypt.RTSecretKeyWrapper;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

public class RTDataCryptEngine {
    private static final String TAG = RTDataCryptEngine.class.getCanonicalName();
    private static final String WRAPPED_KEY = "wrapped_key";
    private static final String KEY_PART_ONE = "MIIBOAIBAAJAW+XLnvNL99fGmjR7aKxrfQRuu9nLyVfNvQ3f1ugf5EHKzIlCS6G8\nijwdwMxIPPFQ/FaY3i9DbgDCY8oXngdo7QIDAQABAkBHM8MSwvuHan4MmMFNltop\noTeTAOsuc4OLCab3Qh8DoS9YLZxAZ7LHQqGjFh4+c3T9MR4G9CPNUjOfJ1TDxl2B\nAiEAqnUqBum+oIulaYTli89syLVPNJUDe9lHCQ4ZpsyJQx0CIQCKA/WwnlsVEAPo\n3oXcZgHeQLn1GVsoBL0bbSsAU1uEEQIgDQaG/6A9AOeq7DVLlTN0jKHOO6Znbb9c\nvkRlkWlv08ECIENHGN5G42mKDA3ZY3GDvEdmT//do2UHolObTMn02HixAiBX9/jy\ntalOPaCX9766MhmzhLfciEtuEogZ9gsBs8piug";
    private SharedPreferences privatePrefs;
    private boolean isJB43orNonTransferable;
    private RTSecretKeyWrapper secretKeyWrapper;
    private String keychainKey;
    private Context context;
    private String password;

    public RTDataCryptEngine(Context context) {
        this(context, false);
    }

    public RTDataCryptEngine(Context context, boolean transferable) {
        this.context = context.getApplicationContext();
        this.privatePrefs = context.getSharedPreferences("RTDataCryptEnginePrefs", 0);
        this.isJB43orNonTransferable = !transferable || Build.VERSION.SDK_INT >= 18;
        this.init();
    }

    private void init() {
        if (this.isJB43orNonTransferable) {
            try {
                this.secretKeyWrapper = new RTSecretKeyWrapper(this.context, this.getSecretKeyAlias());
            }
            catch (Exception e) {
                this.keychainKey = this.generateDefaultKeychainKeyPassword(this.context, this.password);
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        } else {
            this.keychainKey = this.generateDefaultKeychainKeyPassword(this.context, this.password);
        }
    }

    private String getSecretKeyAlias() {
        return String.format("%s%s", this.context.getPackageName(), ".secure_key");
    }

    protected String generateDefaultKeychainKeyPassword(Context context, String userPartOfPassword) {
        String keychain = String.format("%s%s%s", RTDataCryptEngine.class.getSimpleName(), KEY_PART_ONE, context.getString(R.string.key_part_two));
        if (!TextUtils.isEmpty((CharSequence)userPartOfPassword)) {
            return String.format("%s%s", keychain, userPartOfPassword);
        }
        return keychain;
    }

    public void reset() {
        this.privatePrefs.edit().clear().apply();
        if (this.isKWInit()) {
            this.secretKeyWrapper.removeKey(this.getSecretKeyAlias());
        }
        this.init();
    }

    public boolean isKWInit() {
        return this.secretKeyWrapper != null;
    }

    public String decryptString(String encrypted) throws Throwable {
        return this.isKWInit() ? this.decryptWithSecretKey(encrypted) : RTCryptUtil.decryptAsText(encrypted, this.keychainKey);
    }

    private String decryptWithSecretKey(String cipherText) throws Throwable {
        return RTCryptUtil.decryptAesCbc(cipherText, this.getKey(true));
    }

    private SecretKey getKey(boolean generateIfNeeded) throws GeneralSecurityException {
        SecretKey key = null;
        String wrappedKey = this.getWrappedKey();
        if (TextUtils.isEmpty((CharSequence)wrappedKey) && generateIfNeeded) {
            key = RTCryptUtil.createAesKey();
            wrappedKey = Base64.encodeToString((byte[])this.secretKeyWrapper.wrap(key), (int)2);
            this.saveWrappedKey(wrappedKey);
        } else if (!TextUtils.isEmpty((CharSequence)wrappedKey)) {
            key = this.secretKeyWrapper.unwrap(Base64.decode((String)wrappedKey, (int)2));
        }
        return key;
    }

    private String getWrappedKey() {
        return this.privatePrefs.getString(WRAPPED_KEY, "");
    }

    private void saveWrappedKey(String wrappedKey) {
        SharedPreferences.Editor editor = this.privatePrefs.edit();
        editor.putString(WRAPPED_KEY, wrappedKey);
        editor.apply();
    }

    public String encryptString(String value) throws Throwable {
        return this.isKWInit() ? this.encryptWithSecretKey(value) : RTCryptUtil.encrypt(value, this.keychainKey);
    }

    private String encryptWithSecretKey(String plaintext) throws Throwable {
        return RTCryptUtil.encryptAesCbc(plaintext, this.getKey(true));
    }
}

