/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.crypt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import android.util.Log;
import eu.livotov.labs.android.robotools.text.RTBase64;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.x500.X500Principal;

public class RTCryptUtil {
    public static final String PKCS12_DERIVATION_ALGORITHM = "PBEWITHSHA256AND256BITAES-CBC-BC";
    private static final String TAG = RTCryptUtil.class.getSimpleName();
    private static final String PBKDF2_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int PKCS5_SALT_LENGTH = 8;
    private static String DELIMITER = "]";
    private static int KEY_LENGTH = 256;
    private static int KEY_LENGTH_AES = 192;
    private static int ITERATION_COUNT = 1000;
    private static SecureRandom random = new SecureRandom();

    public static String encrypt(String plaintext, String password) {
        byte[] salt = RTCryptUtil.generateSalt();
        SecretKey key = null;
        try {
            key = RTCryptUtil.createKeyPbkdf2(salt, password);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (key == null) {
            key = RTCryptUtil.createKeyPkcs12(salt, password);
        }
        try {
            return RTCryptUtil.encrypt(plaintext.getBytes("UTF-8"), key, salt);
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected static byte[] generateSalt() {
        byte[] b = new byte[8];
        random.nextBytes(b);
        return b;
    }

    protected static SecretKey createKeyPbkdf2(byte[] salt, String password) {
        return RTCryptUtil.createKeyPkcs12(salt, password);
    }

    protected static SecretKey createKeyPkcs12(byte[] salt, String password) {
        try {
            long start = System.currentTimeMillis();
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, ITERATION_COUNT, KEY_LENGTH);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PKCS12_DERIVATION_ALGORITHM);
            SecretKey result = keyFactory.generateSecret(keySpec);
            long elapsed = System.currentTimeMillis() - start;
            Log.d((String)TAG, (String)String.format("PKCS#12 key derivation took %d [ms].", elapsed));
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String encrypt(byte[] plaintext, SecretKey key, byte[] salt) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            byte[] iv = RTCryptUtil.generateIv(cipher.getBlockSize());
            Log.d((String)TAG, (String)("IV: " + RTCryptUtil.toHex(iv)));
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)key, ivParams);
            Log.d((String)TAG, (String)("Cipher IV: " + (cipher.getIV() == null ? null : RTCryptUtil.toHex(cipher.getIV()))));
            byte[] cipherText = cipher.doFinal(plaintext);
            if (salt != null) {
                return String.format("%s%s%s%s%s", RTCryptUtil.toBase64(salt), DELIMITER, RTCryptUtil.toBase64(iv), DELIMITER, RTCryptUtil.toBase64(cipherText));
            }
            return String.format("%s%s%s", RTCryptUtil.toBase64(iv), DELIMITER, RTCryptUtil.toBase64(cipherText));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected static byte[] generateIv(int length) {
        byte[] b = new byte[length];
        random.nextBytes(b);
        return b;
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (byte b : bytes) {
            buff.append(String.format("%02X", b));
        }
        return buff.toString();
    }

    private static String toBase64(byte[] bytes) {
        return RTBase64.encodeToString(bytes, 2);
    }

    public static String encrypt(byte[] plaintext, String password) {
        byte[] salt = RTCryptUtil.generateSalt();
        SecretKey key = null;
        try {
            key = RTCryptUtil.createKeyPbkdf2(salt, password);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (key == null) {
            key = RTCryptUtil.createKeyPkcs12(salt, password);
        }
        return RTCryptUtil.encrypt(plaintext, key, salt);
    }

    public static byte[] decryptAsBytes(String ciphertext, String password) {
        String[] fields = ciphertext.split(DELIMITER);
        if (fields.length != 3) {
            throw new IllegalArgumentException("Invalid encrypted text format");
        }
        byte[] salt = RTCryptUtil.fromBase64(fields[0]);
        byte[] iv = RTCryptUtil.fromBase64(fields[1]);
        byte[] cipherBytes = RTCryptUtil.fromBase64(fields[2]);
        SecretKey key = null;
        try {
            key = RTCryptUtil.createKeyPbkdf2(salt, password);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (key == null) {
            key = RTCryptUtil.createKeyPkcs12(salt, password);
        }
        return RTCryptUtil.decrypt(cipherBytes, key, iv);
    }

    private static byte[] fromBase64(String base64) {
        return RTBase64.decode(base64, 2);
    }

    protected static byte[] decrypt(byte[] cipherBytes, SecretKey key, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivParams);
            Log.d((String)TAG, (String)("Cipher IV: " + RTCryptUtil.toHex(cipher.getIV())));
            return cipher.doFinal(cipherBytes);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAsText(String ciphertext, String password) {
        String[] fields = ciphertext.split(DELIMITER);
        if (fields.length != 3) {
            throw new IllegalArgumentException("Invalid encrypted text format");
        }
        byte[] salt = RTCryptUtil.fromBase64(fields[0]);
        byte[] iv = RTCryptUtil.fromBase64(fields[1]);
        byte[] cipherBytes = RTCryptUtil.fromBase64(fields[2]);
        SecretKey key = null;
        try {
            key = RTCryptUtil.createKeyPbkdf2(salt, password);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (key == null) {
            key = RTCryptUtil.createKeyPkcs12(salt, password);
        }
        try {
            return new String(RTCryptUtil.decrypt(cipherBytes, key, iv), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String encryptAesCbc(String plaintext, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            byte[] iv = RTCryptUtil.generateIv(cipher.getBlockSize());
            Log.d((String)TAG, (String)("IV: " + RTCryptUtil.toHex(iv)));
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)key, ivParams);
            Log.d((String)TAG, (String)("Cipher IV: " + (cipher.getIV() == null ? null : RTCryptUtil.toHex(cipher.getIV()))));
            byte[] cipherText = cipher.doFinal(plaintext.getBytes("UTF-8"));
            return String.format("%s%s%s", RTCryptUtil.toBase64(iv), DELIMITER, RTCryptUtil.toBase64(cipherText));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAesCbc(String ciphertext, SecretKey key) {
        try {
            String[] fields = ciphertext.split(DELIMITER);
            if (fields.length != 2) {
                throw new IllegalArgumentException("Invalid encypted text format");
            }
            byte[] iv = RTCryptUtil.fromBase64(fields[0]);
            byte[] cipherBytes = RTCryptUtil.fromBase64(fields[1]);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivParams);
            Log.d((String)TAG, (String)("Cipher IV: " + RTCryptUtil.toHex(cipher.getIV())));
            byte[] plaintext = cipher.doFinal(cipherBytes);
            return new String(plaintext, "UTF-8");
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey createAesKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(KEY_LENGTH_AES);
            return kg.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static KeyPair createRsaKey(Context ctx, String alais) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        Calendar notBefore = Calendar.getInstance();
        Calendar notAfter = Calendar.getInstance();
        notAfter.add(1, 20);
        KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(ctx).setAlias(alais).setSubject(new X500Principal(String.format("CN=%s, OU=%s", alais, ctx.getPackageName()))).setSerialNumber(BigInteger.ONE).setStartDate(notBefore.getTime()).setEndDate(notAfter.getTime()).build();
        KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
        kpGenerator.initialize((AlgorithmParameterSpec)spec);
        return kpGenerator.generateKeyPair();
    }

    public static String md5(String input) {
        String res = "";
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(input.getBytes());
            byte[] md5 = algorithm.digest();
            int len = md5.length;
            StringBuilder buf = new StringBuilder(len * 2);
            for (int i = 0; i < len; ++i) {
                String tmp = Integer.toHexString(0xFF & md5[i]);
                if (tmp.length() == 1) {
                    buf.append('0');
                }
                buf.append(tmp);
            }
            res = buf.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return res;
    }

    public static byte[] md5bytes(String input) {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(input.getBytes("utf-8"));
            return algorithm.digest();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static void listAlgorithms(String algFilter) {
        Provider[] providers;
        for (Provider p : providers = Security.getProviders()) {
            String providerStr = String.format("%s/%s/%f\n", p.getName(), p.getInfo(), p.getVersion());
            Log.d((String)TAG, (String)providerStr);
            Set<Provider.Service> services = p.getServices();
            ArrayList<String> algs = new ArrayList<String>();
            for (Provider.Service s : services) {
                boolean match = true;
                if (algFilter != null) {
                    match = s.getAlgorithm().toLowerCase().contains(algFilter.toLowerCase());
                }
                if (!match) continue;
                String algStr = String.format("\t%s/%s/%s", s.getType(), s.getAlgorithm(), s.getClassName());
                algs.add(algStr);
            }
            Collections.sort(algs);
            for (String alg : algs) {
                Log.d((String)TAG, (String)("\t" + alg));
            }
            Log.d((String)TAG, (String)"");
        }
    }
}

