/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.crypt;

import android.content.Context;
import eu.livotov.labs.android.robotools.crypt.RTCryptUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class RTSecretKeyWrapper {
    private final Cipher mCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
    private final KeyPair mPair;
    private final KeyStore mKeyStore = KeyStore.getInstance("AndroidKeyStore");

    public RTSecretKeyWrapper(Context context, String alias) throws GeneralSecurityException, IOException {
        this.mKeyStore.load(null);
        if (!this.mKeyStore.containsAlias(alias)) {
            RTCryptUtil.createRsaKey(context, alias);
        }
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.mKeyStore.getEntry(alias, null);
        this.mPair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
    }

    public byte[] wrap(SecretKey key) throws GeneralSecurityException {
        this.mCipher.init(3, this.mPair.getPublic());
        return this.mCipher.wrap(key);
    }

    public SecretKey unwrap(byte[] blob) throws GeneralSecurityException {
        this.mCipher.init(4, this.mPair.getPrivate());
        return (SecretKey)this.mCipher.unwrap(blob, "AES", 3);
    }

    public void removeKey(String alias) {
        try {
            if (this.mKeyStore.containsAlias(alias)) {
                this.mKeyStore.deleteEntry(alias);
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }
}

