/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.crypt;

import android.annotation.TargetApi;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class RTFingerprintCryptEngine {
    public static String encrypt(String alias, String initialText) {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            PublicKey publicKey = keyStore.getCertificate(alias).getPublicKey();
            PublicKey unrestrictedPublicKey = KeyFactory.getInstance(publicKey.getAlgorithm()).generatePublic(new X509EncodedKeySpec(publicKey.getEncoded()));
            Cipher input = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
            input.init(1, (Key)unrestrictedPublicKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, input);
            cipherOutputStream.write(initialText.getBytes("UTF-8"));
            cipherOutputStream.close();
            byte[] vals = outputStream.toByteArray();
            return Base64.encodeToString((byte[])vals, (int)0);
        }
        catch (Exception e) {
            Log.e((String)RTFingerprintCryptEngine.class.getSimpleName(), (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public static Cipher initDecryptionRSACipher(String alias) throws IOException, CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeyException {
        KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, null);
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
        cipher.init(2, (Key)privateKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
        return cipher;
    }

    public static String decrypt(Cipher cipher, String cipherText) {
        try {
            int nextByte;
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)cipherText, (int)0)), cipher);
            ArrayList<Byte> values = new ArrayList<Byte>();
            while ((nextByte = cipherInputStream.read()) != -1) {
                values.add((byte)nextByte);
            }
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)values.get(i);
            }
            String finalText = new String(bytes, 0, bytes.length, "UTF-8");
            return finalText;
        }
        catch (Exception e) {
            Log.e((String)RTFingerprintCryptEngine.class.getSimpleName(), (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    @TargetApi(value=23)
    public static KeyPair createRSAKeyUserAuthenticationRequired(String alias) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
            keyPairGenerator.initialize((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(alias, 2).setDigests(new String[]{"SHA-256", "SHA-512"}).setUserAuthenticationRequired(true).setEncryptionPaddings(new String[]{"OAEPPadding"}).build());
            return keyPairGenerator.generateKeyPair();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

