/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.settings;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.Log;
import eu.livotov.labs.android.robotools.crypt.RTCryptUtil;
import eu.livotov.labs.android.robotools.settings.RTPrefs;
import eu.livotov.labs.android.robotools.settings.RTSecurePrefs;
import eu.livotov.labs.android.robotools.text.RTBase64;
import java.util.Set;

public class RTUserPinSecurePrefs
extends RTSecurePrefs {
    private static final String PIN_PRESENT_KEY = "pincheck";
    private static final String MASK = "f8989fuojJKLJLKS09-0983";
    private String locker;

    public RTUserPinSecurePrefs(Context ctx, @NonNull String preferenceStorageName) {
        super(ctx, preferenceStorageName, true);
    }

    public boolean isLocked() {
        return this.innerPrefs.getBoolean(PIN_PRESENT_KEY, false) && !TextUtils.isEmpty((CharSequence)this.locker);
    }

    public boolean unlock(@NonNull String password) {
        if (this.isLocked()) {
            try {
                Set keys = this.innerPrefs.getPreferences().getAll().keySet();
                for (String key : keys) {
                    String rawValue;
                    if (PIN_PRESENT_KEY.equalsIgnoreCase(key) || TextUtils.isEmpty((CharSequence)(rawValue = "" + super.getString(key, "")))) continue;
                    RTCryptUtil.decryptAsText(rawValue, password);
                    break;
                }
                this.locker = RTCryptUtil.encrypt(password, MASK);
                return true;
            }
            catch (Throwable err) {
                Log.d((String)RTUserPinSecurePrefs.class.getSimpleName(), (String)err.getMessage());
                return false;
            }
        }
        return true;
    }

    public void lock() {
        if (!TextUtils.isEmpty((CharSequence)this.locker)) {
            this.locker = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPassword(@Nullable String oldPassword, @Nullable String newPassword) {
        boolean markerPresent = this.innerPrefs.getBoolean(PIN_PRESENT_KEY, false);
        if (markerPresent) {
            if (TextUtils.isEmpty((CharSequence)oldPassword)) {
                throw new IllegalArgumentException("Preferences are encrypted. In order to change the password you must provide an old one for security purposes !");
            }
            this.lock();
            if (!this.unlock(oldPassword)) throw new IllegalArgumentException("Preferences are encrypted. Current password is invalid !");
            Set keys = this.innerPrefs.getPreferences().getAll().keySet();
            for (String key : keys) {
                if (PIN_PRESENT_KEY.equalsIgnoreCase(key)) continue;
                if (TextUtils.isEmpty((CharSequence)newPassword)) {
                    super.setString(key, RTCryptUtil.decryptAsText(super.getString(key, ""), oldPassword));
                    continue;
                }
                super.setString(key, RTCryptUtil.encrypt(RTCryptUtil.decryptAsText(super.getString(key, ""), oldPassword), newPassword));
            }
            if (TextUtils.isEmpty((CharSequence)newPassword)) {
                this.locker = null;
                this.innerPrefs.remove(PIN_PRESENT_KEY);
                return;
            } else {
                this.locker = RTCryptUtil.encrypt(newPassword, MASK);
            }
            return;
        } else {
            if (TextUtils.isEmpty((CharSequence)newPassword)) {
                throw new IllegalArgumentException("When setting up the new password, it cannot be emoty !");
            }
            Set keys = this.innerPrefs.getPreferences().getAll().keySet();
            for (String key : keys) {
                if (PIN_PRESENT_KEY.equalsIgnoreCase(key)) continue;
                super.setString(key, RTCryptUtil.encrypt(super.getString(key, ""), newPassword));
                this.locker = RTCryptUtil.encrypt(newPassword, MASK);
                this.innerPrefs.setBoolean(PIN_PRESENT_KEY, true);
            }
        }
    }

    @Override
    public String getString(@StringRes int key, String defaultValue) {
        return this.userDecryptString(super.getString(key, defaultValue));
    }

    @Override
    public String getString(@NonNull String key, String defaultValue) {
        return this.userDecryptString(super.getString(key, defaultValue));
    }

    @Override
    public int getInt(@StringRes int key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key, "" + defaultValue));
        }
        catch (NumberFormatException err) {
            return defaultValue;
        }
    }

    @Override
    public int getInt(@NonNull String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key, "" + defaultValue));
        }
        catch (NumberFormatException err) {
            return defaultValue;
        }
    }

    @Override
    public void setInt(@StringRes int key, int value) {
        this.setString(key, "" + value);
    }

    @Override
    public void setString(@StringRes int key, String value) {
        super.setString(key, this.userEncryptString(value));
    }

    @Override
    public void setString(@NonNull String key, String value) {
        super.setString(key, this.userEncryptString(value));
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void setInt(@NonNull String key, int value) {
        this.setString(key, "" + value);
    }

    @Override
    public long getLong(@StringRes int key, long defaultValue) {
        try {
            return Long.parseLong(this.getString(key, "" + defaultValue));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(@NonNull String key, long defaultValue) {
        try {
            return Long.parseLong(this.getString(key, "" + defaultValue));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setIntArray(@StringRes int key, int[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    @Override
    public void setIntArray(@NonNull String key, int[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    @Override
    public void setLongArray(@StringRes int key, long[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    @Override
    public void setLongArray(@NonNull String key, long[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    @Override
    public void setByteArray(@StringRes int key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    @Override
    public void setByteArray(@NonNull String key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    @Override
    public int[] getIntArray(@StringRes int key) {
        return RTPrefs.stringToIntegerArray(this.getString(key, ""));
    }

    @Override
    public int[] getIntArray(@NonNull String key) {
        return RTPrefs.stringToIntegerArray(this.getString(key, ""));
    }

    @Override
    public long[] getLongArray(@StringRes int key) {
        return RTPrefs.stringToLongArray(this.getString(key, ""));
    }

    @Override
    public long[] getLongArray(@NonNull String key) {
        return RTPrefs.stringToLongArray(this.getString(key, ""));
    }

    @Override
    public byte[] getByteArray(@StringRes int key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    @Override
    public byte[] getByteArray(@NonNull String key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    @Override
    public void setLong(@StringRes int key, long value) {
        this.setString(key, "" + value);
    }

    @Override
    public void setLong(@NonNull String key, long value) {
        this.setString(key, "" + value);
    }

    @Override
    public void setDouble(@StringRes int key, double value) {
        this.setString(key, "" + value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.setString(key, "" + value);
    }

    @Override
    public double getDouble(@StringRes int key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, "" + defaultValue));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(@NonNull String key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, "" + defaultValue));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(@StringRes int key, boolean defaultValue) {
        String dv = this.getString(key, "D");
        if ("D".equalsIgnoreCase(dv)) {
            return defaultValue;
        }
        return "1".equalsIgnoreCase(dv);
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        String dv = this.getString(key, "D");
        if ("D".equalsIgnoreCase(dv)) {
            return defaultValue;
        }
        return "1".equalsIgnoreCase(dv);
    }

    @Override
    public void setBoolean(@StringRes int key, boolean value) {
        this.setString(key, value ? "1" : "0");
    }

    @Override
    public void setBoolean(@NonNull String key, boolean value) {
        this.setString(key, value ? "1" : "0");
    }

    @Override
    public <T> T getObject(Class<T> clazz, @StringRes int key, T defaultValue) {
        String json = this.getString(key, null);
        try {
            return (T)this.innerPrefs.gson.fromJson(json, clazz);
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    @Override
    public <T> T getObject(Class<T> clazz, @NonNull String key, T defaultValue) {
        String json = this.getString(key, null);
        try {
            return (T)this.innerPrefs.gson.fromJson(json, clazz);
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    @Override
    public void setObject(@StringRes int key, Object object) {
        this.setString(key, this.innerPrefs.gson.toJson(object));
    }

    @Override
    public void setObject(@NonNull String key, Object object) {
        this.setString(key, this.innerPrefs.gson.toJson(object));
    }

    private String userEncryptString(String src) {
        boolean markerPresent = this.innerPrefs.getBoolean(PIN_PRESENT_KEY, false);
        if (markerPresent) {
            if (!TextUtils.isEmpty((CharSequence)this.locker)) {
                return RTCryptUtil.encrypt(src, RTCryptUtil.decryptAsText(this.locker, MASK));
            }
            throw new RuntimeException("Preferences are locked. Call unlock(password) first !");
        }
        return src;
    }

    private String userDecryptString(String src) {
        boolean markerPresent = this.innerPrefs.getBoolean(PIN_PRESENT_KEY, false);
        if (markerPresent) {
            if (!TextUtils.isEmpty((CharSequence)this.locker)) {
                return RTCryptUtil.decryptAsText(src, RTCryptUtil.decryptAsText(this.locker, MASK));
            }
            throw new RuntimeException("Preferences are locked. Call unlock(password) first !");
        }
        return src;
    }
}

