/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.settings;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import com.google.gson.Gson;
import eu.livotov.labs.android.robotools.text.RTBase64;
import java.util.StringTokenizer;

public class RTPrefs {
    protected static RTPrefs defaultPreferences = null;
    protected SharedPreferences preferences;
    protected Context ctx;
    protected Gson gson = new Gson();

    public RTPrefs(@NonNull Context ctx) {
        this(ctx, null, false);
    }

    public RTPrefs(@NonNull Context ctx, @Nullable String preferenceStorageName, boolean privateMode) {
        this.ctx = ctx.getApplicationContext();
        this.preferences = TextUtils.isEmpty((CharSequence)preferenceStorageName) ? PreferenceManager.getDefaultSharedPreferences((Context)ctx) : ctx.getSharedPreferences(preferenceStorageName, RTPrefs.getPrefsMode(privateMode));
    }

    protected static int getPrefsMode(boolean privateMode) {
        if (Build.VERSION.SDK_INT >= 11 && !privateMode) {
            return 4;
        }
        return 0;
    }

    public RTPrefs(@NonNull Context ctx, @Nullable String preferenceStorageName) {
        this(ctx, preferenceStorageName, false);
    }

    public static synchronized RTPrefs getDefault(@NonNull Context ctx) {
        if (defaultPreferences == null) {
            defaultPreferences = new RTPrefs(ctx, null);
        }
        return defaultPreferences;
    }

    public int getInt(@StringRes int key, int defaultValue) {
        return this.getInt(this.ctx.getString(key), defaultValue);
    }

    public int getInt(@NonNull String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    public void setInt(@StringRes int key, int value) {
        this.setInt(this.ctx.getString(key), value);
    }

    public void setInt(String key, int value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public long getLong(@StringRes int key, long defaultValue) {
        return this.getLong(this.ctx.getString(key), defaultValue);
    }

    public long getLong(@NonNull String key, long defaultValue) {
        try {
            return this.preferences.getLong(key, defaultValue);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return 0L;
        }
    }

    public void setLong(@StringRes int key, long value) {
        this.setLong(this.ctx.getString(key), value);
    }

    public void setLong(@NonNull String key, long value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    public void setDouble(@StringRes int key, double value) {
        this.setDouble(this.ctx.getString(key), value);
    }

    public void setDouble(@NonNull String key, double value) {
        this.setString(key, "" + value);
    }

    public void setString(@NonNull String key, String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public double getDouble(@StringRes int key, double defaultValue) {
        return this.getDouble(this.ctx.getString(key), defaultValue);
    }

    public double getDouble(@NonNull String key, double defaultValue) {
        try {
            return Double.parseDouble(this.getString(key, "" + defaultValue));
        }
        catch (Throwable err) {
            return defaultValue;
        }
    }

    public String getString(@NonNull String key, String defaultValue) {
        return this.preferences.getString(key, defaultValue);
    }

    public boolean getBoolean(@StringRes int key, boolean defaultValue) {
        return this.getBoolean(this.ctx.getString(key), defaultValue);
    }

    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    public void setBoolean(@StringRes int key, boolean value) {
        this.setBoolean(this.ctx.getString(key), value);
    }

    public void setBoolean(@NonNull String key, boolean value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public void setIntArray(@StringRes int key, int[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setString(@StringRes int key, String value) {
        this.setString(this.ctx.getString(key), value);
    }

    protected static String arrayToString(int[] array) {
        StringBuffer str = new StringBuffer();
        for (int a : array) {
            if (str.length() > 0) {
                str.append("|");
            }
            str.append("" + a);
        }
        return str.toString();
    }

    public void setIntArray(@NonNull String key, int[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setLongArray(@StringRes int key, long[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    protected static String arrayToString(long[] array) {
        StringBuffer str = new StringBuffer();
        for (long a : array) {
            if (str.length() > 0) {
                str.append("|");
            }
            str.append("" + a);
        }
        return str.toString();
    }

    public void setLongArray(@NonNull String key, long[] array) {
        this.setString(key, RTPrefs.arrayToString(array));
    }

    public void setByteArray(@StringRes int key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    public void setByteArray(@NonNull String key, byte[] array) {
        this.setString(key, RTBase64.encodeToString(array, 2));
    }

    public int[] getIntArray(@StringRes int key) {
        return RTPrefs.stringToIntegerArray(this.getString(key, ""));
    }

    protected static int[] stringToIntegerArray(String str) {
        StringTokenizer tok = new StringTokenizer(str, "|", false);
        if (tok.countTokens() > 0) {
            int[] arr = new int[tok.countTokens()];
            int index = 0;
            while (tok.hasMoreTokens()) {
                arr[index] = Integer.parseInt(tok.nextToken());
                ++index;
            }
            return arr;
        }
        return null;
    }

    public String getString(@StringRes int key, String defaultValue) {
        return this.getString(this.ctx.getString(key), defaultValue);
    }

    public int[] getIntArray(@NonNull String key) {
        return RTPrefs.stringToIntegerArray(this.getString(key, ""));
    }

    public long[] getLongArray(@StringRes int key) {
        return RTPrefs.stringToLongArray(this.getString(key, ""));
    }

    protected static long[] stringToLongArray(String str) {
        StringTokenizer tok = new StringTokenizer(str, "|", false);
        if (tok.countTokens() > 0) {
            long[] arr = new long[tok.countTokens()];
            int index = 0;
            while (tok.hasMoreTokens()) {
                arr[index] = Long.parseLong(tok.nextToken());
                ++index;
            }
            return arr;
        }
        return null;
    }

    public long[] getLongArray(@NonNull String key) {
        return RTPrefs.stringToLongArray(this.getString(key, ""));
    }

    public byte[] getByteArray(@StringRes int key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    public byte[] getByteArray(@NonNull String key) {
        return RTBase64.decode(this.getString(key, ""), 2);
    }

    public <T> T getObject(Class<T> clazz, @StringRes int key, T defaultValue) {
        return this.getObject(clazz, this.ctx.getString(key), defaultValue);
    }

    public <T> T getObject(Class<T> clazz, @NonNull String key, T defaultValue) {
        try {
            return (T)this.gson.fromJson(this.getString(key, ""), clazz);
        }
        catch (Throwable ignored) {
            return defaultValue;
        }
    }

    public void setObject(@StringRes int key, Object object) {
        this.setObject(this.ctx.getString(key), object);
    }

    public void setObject(@NonNull String key, Object object) {
        try {
            if (object != null) {
                this.setString(key, this.gson.toJson(object));
            } else {
                this.remove(key);
            }
        }
        catch (Throwable err) {
            throw new IllegalArgumentException("Cannot convert to JSON: " + object.toString(), err);
        }
    }

    public void remove(@NonNull String key) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.remove(key);
        editor.apply();
    }

    public void remove(@StringRes int key) {
        this.remove(this.ctx.getString(key));
    }

    public void clear() {
        this.preferences.edit().clear().apply();
    }

    public SharedPreferences getPreferences() {
        return this.preferences;
    }
}

