/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import eu.livotov.labs.android.robotools.permissions.RTPermissionListener;
import eu.livotov.labs.android.robotools.permissions.RTPermissionRationaleToken;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RTPermissions {
    private static volatile RTPermissions sInstance;
    private String permission;
    private int requestCode = -1;
    private WeakReference<Activity> activity;
    private RTPermissionListener listener;
    private AtomicBoolean isRequestingPermission = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTPermissions getInstance() {
        if (sInstance != null) return sInstance;
        Class<RTPermissions> clazz = RTPermissions.class;
        synchronized (RTPermissions.class) {
            sInstance = new RTPermissions();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void registerActivity(Activity activity) {
        this.activity = new WeakReference<Activity>(activity);
    }

    public void unregisterActivity() {
        if (this.activity != null) {
            this.activity.clear();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.onPermissionRequestGranted(requestCode);
        } else {
            this.onPermissionRequestDenied();
        }
    }

    private void onPermissionRequestGranted(int code) {
        this.finishWithGrantedPermission(this.permission, code);
    }

    private void onPermissionRequestDenied() {
        this.finishWithDeniedPermission(this.permission);
    }

    private void finishWithGrantedPermission(String permission, int code) {
        if (this.listener != null) {
            this.listener.onPermissionGranted(permission, code);
        }
        this.isRequestingPermission.set(false);
    }

    private void finishWithDeniedPermission(String permission) {
        if (this.listener != null) {
            this.listener.onPermissionDenied(permission);
        }
        this.isRequestingPermission.set(false);
    }

    public void checkPermission(String permission, RTPermissionListener listener) {
        this.checkPermission(permission, listener, -1);
    }

    public void checkPermission(String permission, RTPermissionListener listener, int requestCode) {
        if (this.isRequestingPermission.getAndSet(true)) {
            throw new IllegalStateException("Only one permission request at a time. Currently handling permission: [" + this.permission + "]");
        }
        this.permission = permission;
        this.listener = listener;
        this.requestCode = requestCode;
        if (this.isContextAlive()) {
            int permissionState = ContextCompat.checkSelfPermission((Context)((Context)this.activity.get()), (String)permission);
            switch (permissionState) {
                case -1: {
                    this.handleDeniedPermission(permission);
                    break;
                }
                default: {
                    this.finishWithGrantedPermission(permission, requestCode);
                }
            }
        }
    }

    private boolean isContextAlive() {
        return this.activity.get() != null;
    }

    private void handleDeniedPermission(String permission) {
        if (this.isContextAlive() && ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.activity.get()), (String)permission)) {
            RTPermissionRationaleToken permissionToken = new RTPermissionRationaleToken(this, permission);
            this.listener.onPermissionRationaleShouldBeShown(permission, permissionToken);
        } else {
            this.requestPermission(permission);
        }
    }

    void requestPermission(String permission) {
        if (this.isContextAlive()) {
            int permissionCode = this.getPermissionCodeForPermission(permission);
            ActivityCompat.requestPermissions((Activity)((Activity)this.activity.get()), (String[])new String[]{permission}, (int)permissionCode);
        }
    }

    private int getPermissionCodeForPermission(String permission) {
        return this.requestCode > 0 ? this.requestCode : 100;
    }

    void onContinuePermissionRequest(String permission) {
        this.requestPermission(permission);
    }

    void onCancelPermissionRequest(String permission) {
        this.finishWithDeniedPermission(permission);
    }
}

