/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.injector;

import android.animation.AnimatorInflater;
import android.app.ActionBar;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectExtra;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectResource;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectServiceConnection;
import eu.livotov.labs.android.robotools.app.injector.ann.InjectView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

final class RTInjectorClassMetaData {
    static final String TAG = "RTInjector";
    static final boolean DEBUG = true;
    int menu;
    int layout;
    int title;
    List<Field> actionBars;
    List<Field> applications;
    List<Pair<Field, String>> systemServices;
    Map<Class, int[]> rootIds;
    Map<Integer, Method> clickers;
    List<Pair<Field, InjectExtra.MetaData>> extras;
    List<IntPair<Field>> fragments;
    List<IntPair<Field>> menuItems;
    List<Pair<Field, InjectResource.MetaData>> resources;
    List<Pair<Field, IntentFilter>> receivers;
    List<Pair<Field, InjectServiceConnection.MetaData>> serviceConnections;
    List<Pair<Field, InjectView.MetaData>> widgets;

    RTInjectorClassMetaData() {
    }

    public void initActionBars(Object to, ActionBar actionBar) {
        if (this.actionBars != null) {
            for (Field field : this.actionBars) {
                try {
                    field.set(to, actionBar);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit(ActionBar.class, field, t);
                }
            }
        }
    }

    public void releaseActionBars(Object to) {
        if (this.actionBars != null) {
            for (Field field : this.actionBars) {
                try {
                    field.set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease(field, t);
                }
            }
        }
    }

    public void initApplications(Object to, Application application) {
        if (this.applications != null) {
            for (Field field : this.applications) {
                try {
                    field.set(to, application);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit(Application.class, field, t);
                }
            }
        }
    }

    public void releaseApplications(Object to) {
        if (this.applications != null) {
            for (Field field : this.applications) {
                try {
                    field.set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease(field, t);
                }
            }
        }
    }

    public void initSystemServices(Object to, Context context) {
        if (this.systemServices != null) {
            for (Pair<Field, String> entry : this.systemServices) {
                try {
                    String serviceId = (String)entry.second;
                    if (serviceId != null) {
                        ((Field)entry.first).set(to, context.getSystemService(serviceId));
                        continue;
                    }
                    throw new IllegalArgumentException("No such system service " + entry.getClass().getSimpleName());
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit("SystemService", (Field)entry.first, t);
                }
            }
        }
    }

    public void releaseSystemServices(Object to) {
        if (this.systemServices != null) {
            for (Pair<Field, String> pair : this.systemServices) {
                try {
                    ((Field)pair.first).set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit("System service", (Field)pair.first, t);
                }
            }
        }
    }

    public void initMenuHierarchy(Object to, MenuInflater inflater, Menu menu) {
        if (this.menu != 0) {
            inflater.inflate(this.menu, menu);
            if (this.menuItems != null) {
                for (IntPair<Field> entry : this.menuItems) {
                    Field field = (Field)entry.first;
                    try {
                        field.set(to, menu.findItem(entry.second));
                    }
                    catch (Throwable t) {
                        RTInjectorClassMetaData.logReportInit(MenuItem.class, field, t);
                    }
                }
            }
        }
    }

    public void releaseMenuHierarchy(Object to) {
        if (this.menuItems != null) {
            for (IntPair<Field> entry : this.menuItems) {
                try {
                    ((Field)entry.first).set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)entry.first, t);
                }
            }
        }
    }

    public void initFragments(Object to, FragmentManager fragmentManager) {
        if (this.fragments != null) {
            for (IntPair<Field> entry : this.fragments) {
                Field field = (Field)entry.first;
                Class<?> clazz = field.getType();
                int id2 = entry.second;
                try {
                    if (entry.first == null || !Fragment.class.isAssignableFrom(clazz)) {
                        entry.first = null;
                        throw new ClassCastException(clazz.getSimpleName() + " is not assignable to " + Fragment.class.getSimpleName());
                    }
                    Fragment fragment = fragmentManager.findFragmentById(id2);
                    if (fragment == null) {
                        fragment = (Fragment)clazz.newInstance();
                        fragmentManager.beginTransaction().add(id2, fragment).commit();
                    }
                    field.set(to, fragment);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit(Fragment.class, field, t);
                }
            }
        }
    }

    public void releaseFragments(Object to) {
        if (this.fragments != null) {
            for (IntPair<Field> entry : this.fragments) {
                try {
                    ((Field)entry.first).set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)entry.first, t);
                }
            }
        }
    }

    public void initReceivers(Object to, Context context) {
        if (this.receivers != null) {
            for (Pair<Field, IntentFilter> entry : this.receivers) {
                try {
                    context.registerReceiver((BroadcastReceiver)((Field)entry.first).get(to), (IntentFilter)entry.second);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit(BroadcastReceiver.class, (Field)entry.first, t);
                }
            }
        }
    }

    public void releaseReceivers(Object to, Context context) {
        if (this.receivers != null) {
            for (Pair<Field, IntentFilter> entry : this.receivers) {
                try {
                    context.unregisterReceiver((BroadcastReceiver)((Field)entry.first).get(to));
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)entry.first, t);
                }
            }
        }
    }

    public void initServiceConnections(Object to, Context context) {
        if (this.serviceConnections != null) {
            for (Pair<Field, InjectServiceConnection.MetaData> entry : this.serviceConnections) {
                Field field = (Field)entry.first;
                InjectServiceConnection.MetaData metaData = (InjectServiceConnection.MetaData)entry.second;
                try {
                    context.bindService(new Intent(context, metaData.clazz), (ServiceConnection)field.get(to), metaData.flag);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit(ServiceConnection.class, field, t);
                }
            }
        }
    }

    public void releaseServiceConnections(Object to, Context context) {
        if (this.serviceConnections != null) {
            for (Pair<Field, InjectServiceConnection.MetaData> entry : this.serviceConnections) {
                try {
                    context.unbindService((ServiceConnection)((Field)entry.first).get(to));
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)entry.first, t);
                }
            }
        }
    }

    public void initResources(Object to, Context context) {
        if (this.resources != null && this.resources.size() > 0) {
            Resources resources = context.getResources();
            TypedValue tv = null;
            for (Pair<Field, InjectResource.MetaData> entry : this.resources) {
                Field field = (Field)entry.first;
                InjectResource.MetaData metaData = (InjectResource.MetaData)entry.second;
                InjectResource.MetaData.Type type = metaData.type;
                int id2 = metaData.id;
                try {
                    if (type != null) {
                        switch (type) {
                            case CharSequence: {
                                field.set(to, resources.getText(id2));
                                break;
                            }
                            case String: {
                                field.set(to, resources.getString(id2));
                                break;
                            }
                            case CharSequenceArray: {
                                field.set(to, resources.getTextArray(id2));
                                break;
                            }
                            case StringArray: {
                                field.set(to, resources.getStringArray(id2));
                                break;
                            }
                            case Drawable: {
                                field.set(to, resources.getDrawable(id2));
                                break;
                            }
                            case Int_: {
                                if (tv == null) {
                                    tv = new TypedValue();
                                }
                                resources.getValue(id2, tv, true);
                                if (tv.type == 5) {
                                    field.setInt(to, (int)TypedValue.complexToDimension((int)tv.data, (DisplayMetrics)resources.getDisplayMetrics()));
                                    break;
                                }
                                field.setInt(to, tv.data);
                                break;
                            }
                            case Float_: {
                                if (tv == null) {
                                    tv = new TypedValue();
                                }
                                resources.getValue(id2, tv, true);
                                if (tv.type == 5) {
                                    field.setFloat(to, TypedValue.complexToDimension((int)tv.data, (DisplayMetrics)resources.getDisplayMetrics()));
                                    break;
                                }
                                if (tv.type == 6) {
                                    field.setFloat(to, TypedValue.complexToFraction((int)tv.data, (float)1.0f, (float)1.0f));
                                    break;
                                }
                                throw new IllegalArgumentException("float type must be used only for dimensions and fraction resources");
                            }
                            case Boolean_: {
                                field.setBoolean(to, resources.getBoolean(id2));
                                break;
                            }
                            case IntArray: {
                                field.set(to, resources.getIntArray(id2));
                                break;
                            }
                            case Animation: {
                                field.set(to, AnimationUtils.loadAnimation((Context)context, (int)id2));
                                break;
                            }
                            case Interpolator: {
                                field.set(to, AnimationUtils.loadInterpolator((Context)context, (int)id2));
                                break;
                            }
                            case Animator: {
                                field.set(to, AnimatorInflater.loadAnimator((Context)context, (int)id2));
                                break;
                            }
                            case XmlResourceParser: {
                                field.set(to, resources.getXml(id2));
                                break;
                            }
                            case Movie: {
                                field.set(to, resources.getMovie(id2));
                                break;
                            }
                            case ColorStateList: {
                                field.set(to, resources.getColorStateList(id2));
                                break;
                            }
                            case Boolean: {
                                field.set(to, resources.getBoolean(id2));
                                break;
                            }
                            case Integer: {
                                if (tv == null) {
                                    tv = new TypedValue();
                                }
                                resources.getValue(id2, tv, true);
                                if (tv.type == 5) {
                                    field.set(to, (int)TypedValue.complexToDimension((int)tv.data, (DisplayMetrics)resources.getDisplayMetrics()));
                                    break;
                                }
                                field.set(to, tv.data);
                                break;
                            }
                            case Float: {
                                if (tv == null) {
                                    tv = new TypedValue();
                                }
                                resources.getValue(id2, tv, true);
                                if (tv.type == 5) {
                                    field.set(to, Float.valueOf(TypedValue.complexToDimension((int)tv.data, (DisplayMetrics)resources.getDisplayMetrics())));
                                    break;
                                }
                                if (tv.type == 6) {
                                    field.set(to, Float.valueOf(TypedValue.complexToFraction((int)tv.data, (float)1.0f, (float)1.0f)));
                                    break;
                                }
                                throw new IllegalArgumentException("Float type must be used only for dimensions and fraction resources");
                            }
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported field type");
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportInit(Resources.class, field, t);
                }
            }
        }
    }

    public void releaseResources(Object to) {
        if (this.resources != null) {
            for (Pair<Field, InjectResource.MetaData> entry : this.resources) {
                try {
                    if (((Field)entry.first).getType().isPrimitive()) continue;
                    ((Field)entry.first).set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)entry.first, t);
                }
            }
        }
    }

    public void initClickers(Object to, View root) {
        if (this.clickers != null && !this.clickers.isEmpty()) {
            ReflectClickListener listener = new ReflectClickListener(to, this.clickers);
            for (Integer id2 : this.clickers.keySet()) {
                root.findViewById(id2.intValue()).setOnClickListener((View.OnClickListener)listener);
            }
        }
    }

    public void initExtras(Object to, Bundle bundle) {
        if (this.extras != null) {
            for (Pair<Field, InjectExtra.MetaData> entry : this.extras) {
                Field field = (Field)entry.first;
                InjectExtra.MetaData metaData = (InjectExtra.MetaData)entry.second;
                InjectExtra.MetaData.Type type = metaData.type;
                String key = metaData.extra;
                if (!bundle.containsKey(key)) continue;
                if (type != null) {
                    try {
                        switch (type) {
                            case String: {
                                field.set(to, bundle.getString(key));
                                break;
                            }
                            case StringArray: {
                                field.set(to, bundle.getStringArray(key));
                                break;
                            }
                            case Int: {
                                field.setInt(to, bundle.getInt(key));
                                break;
                            }
                            case IntArray: {
                                field.set(to, bundle.getIntArray(key));
                                break;
                            }
                            case ParcelableArray: {
                                field.set(to, bundle.getParcelableArray(key));
                                break;
                            }
                            case Parcelable: {
                                field.set(to, bundle.getParcelable(key));
                                break;
                            }
                            case Boolean: {
                                field.setBoolean(to, bundle.getBoolean(key));
                                break;
                            }
                            case BooleanArray: {
                                field.set(to, bundle.getBooleanArray(key));
                                break;
                            }
                            case Bundle: {
                                field.set(to, bundle.getBundle(key));
                                break;
                            }
                            case Byte: {
                                field.setByte(to, bundle.getByte(key));
                                break;
                            }
                            case ByteArray: {
                                field.set(to, bundle.getByteArray(key));
                                break;
                            }
                            case Char: {
                                field.setChar(to, bundle.getChar(key));
                                break;
                            }
                            case CharArray: {
                                field.set(to, bundle.getCharArray(key));
                                break;
                            }
                            case CharSequence: {
                                field.set(to, bundle.getCharSequence(key));
                                break;
                            }
                            case CharSequenceArray: {
                                field.set(to, bundle.getCharSequenceArray(key));
                                break;
                            }
                            case Double: {
                                field.setDouble(to, bundle.getDouble(key));
                                break;
                            }
                            case DoubleArray: {
                                field.set(to, bundle.getDoubleArray(key));
                                break;
                            }
                            case Float: {
                                field.setFloat(to, bundle.getFloat(key));
                                break;
                            }
                            case FloatArray: {
                                field.set(to, bundle.getFloatArray(key));
                                break;
                            }
                            case IBinder: {
                                if (Build.VERSION.SDK_INT < 18) break;
                                field.set(to, bundle.getBinder(key));
                                break;
                            }
                            case ArrayListInteger: {
                                field.set(to, bundle.getIntegerArrayList(key));
                                break;
                            }
                            case ArrayListString: {
                                field.set(to, bundle.getStringArrayList(key));
                                break;
                            }
                            case ArrayListParcelable: {
                                field.set(to, bundle.getParcelableArrayList(key));
                                break;
                            }
                            case Long: {
                                field.setLong(to, bundle.getLong(key));
                                break;
                            }
                            case LongArray: {
                                field.set(to, bundle.getLongArray(key));
                                break;
                            }
                            case Serializable: {
                                field.set(to, bundle.getSerializable(key));
                                break;
                            }
                            case Short: {
                                field.setShort(to, bundle.getShort(key));
                                break;
                            }
                            case ShortArray: {
                                field.set(to, bundle.getShortArray(key));
                                break;
                            }
                            case SparseParcelableArray: {
                                field.set(to, bundle.getSparseParcelableArray(key));
                            }
                        }
                    }
                    catch (Throwable t) {
                        RTInjectorClassMetaData.logReportInit("Extra", field, t);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unsupported field type");
            }
        }
    }

    public void releaseExtras(Object to) {
        if (this.extras != null) {
            for (Pair<Field, InjectExtra.MetaData> field : this.extras) {
                try {
                    if (((Field)field.first).getType().isPrimitive()) continue;
                    ((Field)field.first).set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)field.first, t);
                }
            }
        }
    }

    public View initWidgets(Object to, LayoutInflater inflater, ViewGroup container) {
        View root = null;
        if (this.layout != 0) {
            root = inflater.inflate(this.layout, container, false);
            if (this.widgets != null) {
                for (Pair<Field, InjectView.MetaData> entry : this.widgets) {
                    Field field = (Field)entry.first;
                    InjectView.MetaData data = (InjectView.MetaData)entry.second;
                    try {
                        View view = root.findViewById(data.id);
                        if (view == null) continue;
                        field.set(to, view);
                        int id2 = view.getId();
                    }
                    catch (Throwable t) {
                        RTInjectorClassMetaData.logReportInit("Widget", field, t);
                    }
                }
            }
        }
        return root;
    }

    public void releaseWidgets(Object to) {
        if (this.widgets != null) {
            for (Pair<Field, InjectView.MetaData> entry : this.widgets) {
                try {
                    ((Field)entry.first).set(to, null);
                }
                catch (Throwable t) {
                    RTInjectorClassMetaData.logReportRelease((Field)entry.first, t);
                }
            }
        }
    }

    private static boolean contains(int[] in, int v) {
        for (int i : in) {
            if (i != v) continue;
            return true;
        }
        return false;
    }

    private static void logReportInit(Class value, Field field, Throwable t) {
        RTInjectorClassMetaData.logReportInit(value.getSimpleName(), field, t);
    }

    private static void logReportInit(String value, Field field, Throwable t) {
        Log.e((String)TAG, (String)String.format("Error, %s value on field %s#%s:%s", value, field.getDeclaringClass().getSimpleName(), field.getClass(), field.getName()), (Throwable)t);
    }

    private static void logReportRelease(Field field, Throwable t) {
        Log.e((String)TAG, (String)String.format("Unable to release field %s#%s:%s", field.getDeclaringClass().getSimpleName(), field.getClass(), field.getName()), (Throwable)t);
    }

    static final class IntPair<T> {
        T first;
        int second;

        IntPair(T first, int second) {
            this.first = first;
            this.second = second;
        }
    }

    private static final class ReflectClickListener
    implements View.OnClickListener {
        final Object receiver;
        final Map<Integer, Method> clickers;

        private ReflectClickListener(Object receiver, Map<Integer, Method> clickers) {
            this.receiver = receiver;
            this.clickers = clickers;
        }

        public void onClick(View v) {
            Method method;
            if (this.clickers != null && (method = this.clickers.get(v.getId())) != null) {
                try {
                    method.invoke(this.receiver, new Object[0]);
                }
                catch (Throwable t) {
                    Log.e((String)RTInjectorClassMetaData.TAG, (String)String.format("Unable to invoke method %s() in class %s", method.getName(), this.receiver.getClass().getSimpleName()), (Throwable)t);
                }
            }
        }
    }
}

