/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.design.bottomsheet.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;

public class BottomSheetClosableSlidingLayout
extends FrameLayout {
    private static final int INVALID_POINTER = -1;
    private final float MINVEL;
    View mTarget;
    boolean swipeable = true;
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)0.8f, (ViewDragHelper.Callback)new ViewDragCallback());
    private SlideListener mListener;
    private int height;
    private int top;
    private int mActivePointerId;
    private boolean mIsBeingDragged;
    private float mInitialMotionY;
    private boolean collapsible = false;
    private float yDiff;

    public BottomSheetClosableSlidingLayout(Context context) {
        this(context, null);
    }

    public BottomSheetClosableSlidingLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @TargetApi(value=11)
    public BottomSheetClosableSlidingLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.MINVEL = this.getResources().getDisplayMetrics().density * 400.0f;
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
    }

    public View getmTarget() {
        return this.mTarget;
    }

    public void setmTarget(View mTarget) {
        this.mTarget = mTarget;
    }

    public boolean isSwipeable() {
        return this.swipeable;
    }

    public void setSwipeable(boolean swipeable) {
        this.swipeable = swipeable;
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        if (!this.isEnabled() || this.canChildScrollUp()) {
            return false;
        }
        if (action == 3 || action == 1) {
            this.mActivePointerId = -1;
            this.mIsBeingDragged = false;
            if (this.collapsible && -this.yDiff > (float)this.mDragHelper.getTouchSlop()) {
                this.expand(this.mDragHelper.getCapturedView(), 0.0f);
            }
            this.mDragHelper.cancel();
            return false;
        }
        switch (action) {
            case 0: {
                this.height = this.getChildAt(0).getHeight();
                this.top = this.getChildAt(0).getTop();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)event, (int)0);
                this.mIsBeingDragged = false;
                float initialMotionY = this.getMotionEventY(event, this.mActivePointerId);
                if (initialMotionY == -1.0f) {
                    return false;
                }
                this.mInitialMotionY = initialMotionY;
                this.yDiff = 0.0f;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float y = this.getMotionEventY(event, this.mActivePointerId);
                if (y == -1.0f) {
                    return false;
                }
                this.yDiff = y - this.mInitialMotionY;
                if (!this.swipeable || !(this.yDiff > (float)this.mDragHelper.getTouchSlop()) || this.mIsBeingDragged) break;
                this.mIsBeingDragged = true;
                this.mDragHelper.captureChildView(this.getChildAt(0), 0);
            }
        }
        this.mDragHelper.shouldInterceptTouchEvent(event);
        return this.mIsBeingDragged;
    }

    private boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    private void expand(View releasedChild, float yvel) {
        if (this.mListener != null) {
            this.mListener.onOpened();
        }
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || this.canChildScrollUp()) {
            return super.onTouchEvent(ev);
        }
        try {
            if (this.swipeable) {
                this.mDragHelper.processTouchEvent(ev);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setSlideListener(SlideListener listener) {
        this.mListener = listener;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
    }

    private void dismiss(View view, float yvel) {
        this.mDragHelper.smoothSlideViewTo(view, 0, this.top + this.height);
        this.mDragHelper.cancel();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private ViewDragCallback() {
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            if (Build.VERSION.SDK_INT < 11) {
                BottomSheetClosableSlidingLayout.this.invalidate();
            }
            if (BottomSheetClosableSlidingLayout.this.height - top < 1 && BottomSheetClosableSlidingLayout.this.mListener != null) {
                BottomSheetClosableSlidingLayout.this.mListener.onClosed();
            }
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            if (yvel > BottomSheetClosableSlidingLayout.this.MINVEL) {
                BottomSheetClosableSlidingLayout.this.dismiss(releasedChild, yvel);
            } else if (releasedChild.getTop() >= BottomSheetClosableSlidingLayout.this.top + BottomSheetClosableSlidingLayout.this.height / 2) {
                BottomSheetClosableSlidingLayout.this.dismiss(releasedChild, yvel);
            } else {
                BottomSheetClosableSlidingLayout.this.mDragHelper.smoothSlideViewTo(releasedChild, 0, BottomSheetClosableSlidingLayout.this.top);
            }
            ViewCompat.postInvalidateOnAnimation((View)BottomSheetClosableSlidingLayout.this);
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return true;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return Math.max(top, BottomSheetClosableSlidingLayout.this.top);
        }
    }

    public static interface SlideListener {
        public void onClosed();

        public void onOpened();
    }
}

