/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.animation;

import android.animation.Animator;
import android.view.View;
import android.view.animation.Interpolator;
import eu.livotov.labs.android.robotools.animation.technique.BaseViewAnimator;
import eu.livotov.labs.android.robotools.animation.technique.Technique;
import java.util.ArrayList;
import java.util.List;

public class RTAnimator {
    private static final long DURATION = 1000L;
    private static final long NO_DELAY = 0L;
    private BaseViewAnimator animator;
    private long duration;
    private long delay;
    private Interpolator interpolator;
    private List<Animator.AnimatorListener> callbacks;
    private View target;

    private RTAnimator(AnimationComposer animationComposer) {
        this.animator = animationComposer.animator;
        this.duration = animationComposer.duration;
        this.delay = animationComposer.delay;
        this.interpolator = animationComposer.interpolator;
        this.callbacks = animationComposer.callbacks;
        this.target = animationComposer.target;
    }

    public static AnimationComposer with(Technique technique) {
        return new AnimationComposer(technique);
    }

    public static AnimationComposer with(BaseViewAnimator animator) {
        return new AnimationComposer(animator);
    }

    private BaseViewAnimator play() {
        this.animator.setTarget(this.target);
        this.animator.setDuration(this.duration).setInterpolator(this.interpolator).setStartDelay(this.delay);
        if (this.callbacks.size() > 0) {
            for (Animator.AnimatorListener callback : this.callbacks) {
                this.animator.addAnimatorListener(callback);
            }
        }
        this.animator.animate();
        return this.animator;
    }

    public static final class YoYoString {
        private BaseViewAnimator animator;
        private View target;

        private YoYoString(BaseViewAnimator animator, View target) {
            this.target = target;
            this.animator = animator;
        }

        public boolean isStarted() {
            return this.animator.isStarted();
        }

        public boolean isRunning() {
            return this.animator.isRunning();
        }

        public void stop(boolean reset) {
            this.animator.cancel();
            if (reset) {
                this.animator.reset(this.target);
            }
        }
    }

    public static final class AnimationComposer {
        private List<Animator.AnimatorListener> callbacks = new ArrayList<Animator.AnimatorListener>();
        private BaseViewAnimator animator;
        private long duration = 1000L;
        private long delay = 0L;
        private Interpolator interpolator;
        private View target;

        private AnimationComposer(Technique technique) {
            this.animator = technique.getAnimator();
        }

        private AnimationComposer(BaseViewAnimator animator) {
            this.animator = animator;
        }

        public AnimationComposer duration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnimationComposer delay(long delay) {
            this.delay = delay;
            return this;
        }

        public AnimationComposer interpolate(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public AnimationComposer withListener(Animator.AnimatorListener listener) {
            this.callbacks.add(listener);
            return this;
        }

        public AnimationComposer onStart(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationStart(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public AnimationComposer onEnd(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public AnimationComposer onCancel(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationCancel(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public AnimationComposer onRepeat(final AnimatorCallback callback) {
            this.callbacks.add(new EmptyAnimatorListener(){

                @Override
                public void onAnimationRepeat(Animator animation) {
                    callback.call(animation);
                }
            });
            return this;
        }

        public YoYoString playOn(View target) {
            this.target = target;
            return new YoYoString(new RTAnimator(this).play(), this.target);
        }
    }

    private static class EmptyAnimatorListener
    implements Animator.AnimatorListener {
        private EmptyAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface AnimatorCallback {
        public void call(Animator var1);
    }
}

