/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.injector;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Service;
import android.content.ContentProvider;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import dalvik.system.DexFile;
import eu.livotov.labs.android.robotools.app.injector.RTInjectorClassMetaData;
import eu.livotov.labs.android.robotools.app.injector.RTInjectorClassMetadataLoader;
import java.io.IOException;
import java.util.Enumeration;

public class RTInjector {
    private RTInjector() {
    }

    public static void loadClasses(Class ... classes) {
        if (classes != null) {
            for (Class clazz : classes) {
                RTInjectorClassMetadataLoader.loadClass(clazz);
            }
        }
    }

    public static void loadClasses(Context context, String subpackageName) {
        long start = System.currentTimeMillis();
        int count = 0;
        try {
            String path = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).sourceDir;
            String packageName = context.getPackageName();
            if (!TextUtils.isEmpty((CharSequence)subpackageName)) {
                Log.i((String)"RTInjector", (String)("Detected specific package name for classes : " + subpackageName));
                if (subpackageName.startsWith(".")) {
                    subpackageName = packageName + subpackageName;
                }
            } else {
                subpackageName = packageName;
            }
            Log.i((String)"RTInjector", (String)("Searching for the classes in: " + subpackageName));
            DexFile dexfile = new DexFile(path);
            Enumeration entries = dexfile.entries();
            while (entries.hasMoreElements()) {
                String name = (String)entries.nextElement();
                if (name == null || !name.startsWith(subpackageName)) continue;
                try {
                    Class<?> clazz = Class.forName(name, true, context.getClass().getClassLoader());
                    if (clazz == null) continue;
                    RTInjectorClassMetadataLoader.loadClass(clazz);
                    ++count;
                }
                catch (ClassNotFoundException e) {
                    Log.e((String)"RTInjector", (String)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (PackageManager.NameNotFoundException | IOException e) {
            Log.e((String)"RTInjector", (String)e.getMessage(), (Throwable)e);
        }
        Log.i((String)"RTInjector", (String)String.format("Found %s classes in %s ms", count, System.currentTimeMillis() - start));
    }

    public static final class FragmentInjector {
        final RTInjectorClassMetaData data;
        final Fragment fragment;

        public FragmentInjector(Fragment fragment) {
            this.data = RTInjectorClassMetadataLoader.loadClass(fragment.getClass());
            this.fragment = fragment;
        }

        public void onCreate() {
            Activity activity = this.fragment.getActivity();
            this.data.initApplications(this.fragment, activity.getApplication());
            this.data.initSystemServices(this.fragment, (Context)activity);
            this.data.initResources(this.fragment, (Context)this.fragment.getActivity());
            if (activity instanceof Activity) {
                this.data.initActionBars(this.fragment, activity.getActionBar());
            } else {
                Log.e((String)"Injector", (String)"Cant init ActionBars: Activity myst extends android.support.v7.app.ActionBarActivity");
            }
            Bundle args = this.fragment.getArguments();
            if (args != null) {
                this.data.initExtras(this.fragment, args);
            }
            if (this.data.menu != 0) {
                this.fragment.setHasOptionsMenu(true);
            }
        }

        public void onDestroy() {
            this.data.releaseApplications(this.fragment);
            this.data.releaseSystemServices(this.fragment);
            this.data.releaseResources(this.fragment);
            this.data.releaseActionBars(this.fragment);
            this.data.releaseExtras(this.fragment);
        }

        public void onStart() {
            Activity activity = this.fragment.getActivity();
            this.data.initReceivers(this.fragment, (Context)activity);
            this.data.initServiceConnections(this.fragment, (Context)activity);
        }

        public void onStop() {
            Activity activity = this.fragment.getActivity();
            this.data.releaseReceivers(this.fragment, (Context)activity);
            this.data.releaseServiceConnections(this.fragment, (Context)activity);
        }

        public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
            this.data.initMenuHierarchy(this.fragment, inflater, menu);
        }

        public void onDestroyOptionsMenu() {
            this.data.releaseMenuHierarchy(this.fragment);
        }

        @TargetApi(value=17)
        public View onCreateView(LayoutInflater inflater, ViewGroup container) {
            View root;
            if (this.data.title != 0) {
                this.fragment.getActivity().setTitle(this.data.title);
            }
            if ((root = this.data.initWidgets(this.fragment, inflater, container)) != null) {
                this.data.initClickers(this.fragment, root);
            }
            this.data.initFragments(this.fragment, Build.VERSION.SDK_INT >= 17 ? this.fragment.getChildFragmentManager() : this.fragment.getFragmentManager());
            return root;
        }

        public void onDestroyView() {
            this.data.releaseWidgets(this.fragment);
            this.data.releaseFragments(this.fragment);
        }
    }

    public static final class ActivityInjector {
        final RTInjectorClassMetaData data;
        final Activity activity;

        public ActivityInjector(Activity activity) {
            this.data = RTInjectorClassMetadataLoader.loadClass(activity.getClass());
            this.activity = activity;
        }

        public void onCreate() {
            View contentView;
            this.data.initApplications(this.activity, this.activity.getApplication());
            this.data.initSystemServices(this.activity, (Context)this.activity);
            this.data.initResources(this.activity, (Context)this.activity);
            this.data.initActionBars(this.activity, this.activity.getActionBar());
            Bundle extras = this.activity.getIntent().getExtras();
            if (extras != null) {
                this.data.initExtras(this.activity, extras);
            }
            if ((contentView = this.data.initWidgets(this.activity, this.activity.getLayoutInflater(), null)) != null) {
                this.activity.setContentView(contentView);
                this.data.initClickers(this.activity, contentView);
            }
            this.data.initFragments(this.activity, this.activity.getFragmentManager());
            if (this.data.title != 0) {
                this.activity.setTitle(this.data.title);
            }
        }

        public void onCreateOptionsMenu(Menu menu) {
            this.data.initMenuHierarchy(this.activity, this.activity.getMenuInflater(), menu);
        }

        public void onStart() {
            this.data.initReceivers(this.activity, (Context)this.activity);
            this.data.initServiceConnections(this.activity, (Context)this.activity);
        }

        public void onStop() {
            this.data.releaseReceivers(this.activity, (Context)this.activity);
            this.data.releaseServiceConnections(this.activity, (Context)this.activity);
        }

        public void onDestroy() {
            this.data.releaseApplications(this.activity);
            this.data.releaseSystemServices(this.activity);
            this.data.releaseResources(this.activity);
            this.data.releaseActionBars(this.activity);
            this.data.releaseExtras(this.activity);
            this.data.releaseWidgets(this.activity);
            this.data.releaseFragments(this.activity);
            this.data.releaseMenuHierarchy(this.activity);
        }
    }

    public static final class ContentProviderInjector {
        final RTInjectorClassMetaData data;
        final ContentProvider contentProvider;

        public ContentProviderInjector(ContentProvider contentProvider) {
            this.data = RTInjectorClassMetadataLoader.loadClass(contentProvider.getClass());
            this.contentProvider = contentProvider;
        }

        public void onCreate() {
            this.data.initSystemServices(this.contentProvider, this.contentProvider.getContext());
            this.data.initResources(this.contentProvider, this.contentProvider.getContext());
        }
    }

    public static final class ApplicationInjector {
        final RTInjectorClassMetaData data;
        final Application application;

        public ApplicationInjector(Application application) {
            this.data = RTInjectorClassMetadataLoader.loadClass(application.getClass());
            this.application = application;
        }

        public void onCreate() {
            this.data.initSystemServices(this.application, (Context)this.application);
            this.data.initResources(this.application, (Context)this.application);
        }
    }

    public static final class ServiceInjector {
        final RTInjectorClassMetaData data;
        final Service service;

        public ServiceInjector(Service service) {
            this.data = RTInjectorClassMetadataLoader.loadClass(service.getClass());
            this.service = service;
        }

        public void onCreate() {
            this.data.initApplications(this.service, this.service.getApplication());
            this.data.initSystemServices(this.service, (Context)this.service);
            this.data.initResources(this.service, (Context)this.service);
            this.data.initReceivers(this.service, (Context)this.service);
            this.data.initServiceConnections(this.service, (Context)this.service);
        }

        public void onDestroy() {
            this.data.releaseApplications(this.service);
            this.data.releaseSystemServices(this.service);
            this.data.releaseResources(this.service);
            this.data.releaseReceivers(this.service, (Context)this.service);
            this.data.releaseServiceConnections(this.service, (Context)this.service);
        }
    }
}

