/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app.design.bottomsheet.adapter;

import android.content.Context;
import android.database.DataSetObserver;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.layout.BottomSheetHeaderLayout;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.view.BottomSheetFillerView;
import eu.livotov.labs.android.robotools.app.design.bottomsheet.view.BottomSheetPinnedSectionGridView;
import java.util.Arrays;
import java.util.Comparator;

public class BottomSheetSimpleSectionedGridAdapter
extends BaseAdapter {
    protected static final int TYPE_FILLER = 0;
    protected static final int TYPE_HEADER = 1;
    protected static final int TYPE_HEADER_FILLER = 2;
    SparseArray<Section> mSections = new SparseArray();
    private boolean mValid = true;
    private int mSectionResourceId;
    private LayoutInflater mLayoutInflater;
    private ListAdapter mBaseAdapter;
    private Section[] mInitialSections = new Section[0];
    private Context mContext;
    private View mLastViewSeen;
    private int mHeaderWidth;
    private int mNumColumns;
    private int mWidth;
    private int mColumnWidth;
    private int mHorizontalSpacing;
    private int mStrechMode;
    private int requestedColumnWidth;
    private int requestedHorizontalSpacing;
    private GridView mGridView;
    private int mHeaderLayoutResId;
    private int mHeaderTextViewResId;

    public BottomSheetSimpleSectionedGridAdapter(Context context, BaseAdapter baseAdapter, int sectionResourceId, int headerLayoutResId, int headerTextViewResId) {
        this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mSectionResourceId = sectionResourceId;
        this.mHeaderLayoutResId = headerLayoutResId;
        this.mHeaderTextViewResId = headerTextViewResId;
        this.mBaseAdapter = baseAdapter;
        this.mContext = context;
        this.mBaseAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                BottomSheetSimpleSectionedGridAdapter.this.mValid = !BottomSheetSimpleSectionedGridAdapter.this.mBaseAdapter.isEmpty();
                BottomSheetSimpleSectionedGridAdapter.this.notifyDataSetChanged();
            }

            public void onInvalidated() {
                BottomSheetSimpleSectionedGridAdapter.this.mValid = false;
                BottomSheetSimpleSectionedGridAdapter.this.notifyDataSetInvalidated();
            }
        });
    }

    public void setGridView(GridView gridView) {
        if (!(gridView instanceof BottomSheetPinnedSectionGridView)) {
            throw new IllegalArgumentException("Does your grid view extends PinnedSectionGridView?");
        }
        this.mGridView = gridView;
        this.mStrechMode = gridView.getStretchMode();
        this.mWidth = gridView.getWidth() - (this.mGridView.getPaddingLeft() + this.mGridView.getPaddingRight());
        this.mNumColumns = ((BottomSheetPinnedSectionGridView)gridView).getNumColumns();
        this.requestedColumnWidth = ((BottomSheetPinnedSectionGridView)gridView).getColumnWidth();
        this.requestedHorizontalSpacing = ((BottomSheetPinnedSectionGridView)gridView).getHorizontalSpacing();
    }

    public void setSections(Section ... sections) {
        this.mInitialSections = sections;
        this.setSections();
    }

    public SparseArray<Section> getmSections() {
        return this.mSections;
    }

    public void setmSections(SparseArray<Section> mSections) {
        this.mSections = mSections;
    }

    public void setSections() {
        this.mSections.clear();
        this.getHeaderSize();
        Arrays.sort(this.mInitialSections, new Comparator<Section>(){

            @Override
            public int compare(Section o, Section o1) {
                return o.firstPosition == o1.firstPosition ? 0 : (o.firstPosition < o1.firstPosition ? -1 : 1);
            }
        });
        int offset = 0;
        for (int i = 0; i < this.mInitialSections.length; ++i) {
            int nextPos;
            int itemsCount;
            int dummyCount;
            Section sectionAdd;
            Section section = this.mInitialSections[i];
            for (int j = 0; j < this.mNumColumns - 1; ++j) {
                sectionAdd = new Section(section.firstPosition, section.title);
                sectionAdd.type = 2;
                sectionAdd.sectionedPosition = sectionAdd.firstPosition + offset;
                this.mSections.append(sectionAdd.sectionedPosition, (Object)sectionAdd);
                ++offset;
            }
            sectionAdd = new Section(section.firstPosition, section.title);
            sectionAdd.type = 1;
            sectionAdd.sectionedPosition = sectionAdd.firstPosition + offset;
            this.mSections.append(sectionAdd.sectionedPosition, (Object)sectionAdd);
            ++offset;
            if (i >= this.mInitialSections.length - 1 || this.mNumColumns == (dummyCount = this.mNumColumns - (itemsCount = (nextPos = this.mInitialSections[i + 1].firstPosition) - section.firstPosition) % this.mNumColumns)) continue;
            for (int k = 0; k < dummyCount; ++k) {
                sectionAdd = new Section(section.firstPosition, section.title);
                sectionAdd.type = 0;
                sectionAdd.sectionedPosition = nextPos + offset;
                this.mSections.append(sectionAdd.sectionedPosition, (Object)sectionAdd);
                ++offset;
            }
        }
        this.notifyDataSetChanged();
    }

    private int getHeaderSize() {
        if (this.mHeaderWidth > 0) {
            return this.mHeaderWidth;
        }
        if (this.mWidth != this.mGridView.getWidth()) {
            this.mStrechMode = this.mGridView.getStretchMode();
            this.mWidth = ((BottomSheetPinnedSectionGridView)this.mGridView).getAvailableWidth() - (this.mGridView.getPaddingLeft() + this.mGridView.getPaddingRight());
            this.mNumColumns = ((BottomSheetPinnedSectionGridView)this.mGridView).getNumColumns();
            this.requestedColumnWidth = ((BottomSheetPinnedSectionGridView)this.mGridView).getColumnWidth();
            this.requestedHorizontalSpacing = ((BottomSheetPinnedSectionGridView)this.mGridView).getHorizontalSpacing();
        }
        int spaceLeftOver = this.mWidth - this.mNumColumns * this.requestedColumnWidth - (this.mNumColumns - 1) * this.requestedHorizontalSpacing;
        switch (this.mStrechMode) {
            case 0: {
                this.mWidth -= spaceLeftOver;
                this.mColumnWidth = this.requestedColumnWidth;
                this.mHorizontalSpacing = this.requestedHorizontalSpacing;
                break;
            }
            case 2: {
                this.mColumnWidth = this.requestedColumnWidth + spaceLeftOver / this.mNumColumns;
                this.mHorizontalSpacing = this.requestedHorizontalSpacing;
                break;
            }
            case 1: {
                this.mColumnWidth = this.requestedColumnWidth;
                if (this.mNumColumns > 1) {
                    this.mHorizontalSpacing = this.requestedHorizontalSpacing + spaceLeftOver / (this.mNumColumns - 1);
                    break;
                }
                this.mHorizontalSpacing = this.requestedHorizontalSpacing + spaceLeftOver;
                break;
            }
            case 3: {
                this.mColumnWidth = this.requestedColumnWidth;
                this.mHorizontalSpacing = this.requestedHorizontalSpacing;
                this.mWidth = this.mWidth - spaceLeftOver + 2 * this.mHorizontalSpacing;
            }
        }
        this.mHeaderWidth = this.mWidth + (this.mNumColumns - 1) * (this.mColumnWidth + this.mHorizontalSpacing);
        return this.mHeaderWidth;
    }

    public int positionToSectionedPosition(int position) {
        int offset = 0;
        for (int i = 0; i < this.mSections.size() && ((Section)this.mSections.valueAt((int)i)).firstPosition <= position; ++i) {
            ++offset;
        }
        return position + offset;
    }

    public int getCount() {
        return this.mValid ? this.mBaseAdapter.getCount() + this.mSections.size() : 0;
    }

    public Object getItem(int position) {
        return this.isSectionHeaderPosition(position) ? this.mSections.get(position) : this.mBaseAdapter.getItem(this.sectionedPositionToPosition(position));
    }

    public boolean isSectionHeaderPosition(int position) {
        return this.mSections.get(position) != null;
    }

    public int sectionedPositionToPosition(int sectionedPosition) {
        if (this.isSectionHeaderPosition(sectionedPosition)) {
            return -1;
        }
        int offset = 0;
        for (int i = 0; i < this.mSections.size() && ((Section)this.mSections.valueAt((int)i)).sectionedPosition <= sectionedPosition; ++i) {
            --offset;
        }
        return sectionedPosition + offset;
    }

    public long getItemId(int position) {
        return this.isSectionHeaderPosition(position) ? (long)(Integer.MAX_VALUE - this.mSections.indexOfKey(position)) : this.mBaseAdapter.getItemId(this.sectionedPositionToPosition(position));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.isSectionHeaderPosition(position)) {
            if (null == convertView) {
                convertView = this.mLayoutInflater.inflate(this.mSectionResourceId, parent, false);
            } else if (null == convertView.findViewById(this.mHeaderLayoutResId)) {
                convertView = this.mLayoutInflater.inflate(this.mSectionResourceId, parent, false);
            }
            switch (((Section)this.mSections.get((int)position)).type) {
                case 1: {
                    BottomSheetHeaderLayout header = (BottomSheetHeaderLayout)convertView.findViewById(this.mHeaderLayoutResId);
                    if (!TextUtils.isEmpty((CharSequence)((Section)this.mSections.get((int)position)).title)) {
                        TextView view = (TextView)convertView.findViewById(this.mHeaderTextViewResId);
                        view.setText(((Section)this.mSections.get((int)position)).title);
                    }
                    header.setHeaderWidth(this.getHeaderSize());
                    break;
                }
                case 2: {
                    BottomSheetHeaderLayout header = (BottomSheetHeaderLayout)convertView.findViewById(this.mHeaderLayoutResId);
                    if (!TextUtils.isEmpty((CharSequence)((Section)this.mSections.get((int)position)).title)) {
                        TextView view = (TextView)convertView.findViewById(this.mHeaderTextViewResId);
                        view.setText(((Section)this.mSections.get((int)position)).title);
                    }
                    header.setHeaderWidth(0);
                    break;
                }
                default: {
                    convertView = this.getFillerView(this.mLastViewSeen);
                    break;
                }
            }
        } else {
            this.mLastViewSeen = convertView = this.mBaseAdapter.getView(this.sectionedPositionToPosition(position), convertView, parent);
        }
        return convertView;
    }

    private BottomSheetFillerView getFillerView(View lastViewSeen) {
        BottomSheetFillerView fillerView = new BottomSheetFillerView(this.mContext);
        fillerView.setMeasureTarget(lastViewSeen);
        return fillerView;
    }

    public boolean hasStableIds() {
        return this.mBaseAdapter.hasStableIds();
    }

    public boolean areAllItemsEnabled() {
        return this.mBaseAdapter.areAllItemsEnabled();
    }

    public boolean isEnabled(int position) {
        return this.isSectionHeaderPosition(position) ? false : this.mBaseAdapter.isEnabled(this.sectionedPositionToPosition(position));
    }

    public int getItemViewType(int position) {
        return this.isSectionHeaderPosition(position) ? this.getViewTypeCount() - 1 : this.mBaseAdapter.getItemViewType(this.sectionedPositionToPosition(position));
    }

    public int getViewTypeCount() {
        return this.mBaseAdapter.getViewTypeCount() + 1;
    }

    public boolean isEmpty() {
        return this.mBaseAdapter.isEmpty();
    }

    public int getHeaderLayoutResId() {
        return this.mHeaderLayoutResId;
    }

    public static class ViewHolder {
        public static <T extends View> T get(View view, int id) {
            View childView;
            SparseArray viewHolder = (SparseArray)view.getTag();
            if (viewHolder == null) {
                viewHolder = new SparseArray();
                view.setTag((Object)viewHolder);
            }
            if ((childView = (View)viewHolder.get(id)) == null) {
                childView = view.findViewById(id);
                viewHolder.put(id, (Object)childView);
            }
            return (T)childView;
        }
    }

    public static class Section {
        int firstPosition;
        int sectionedPosition;
        CharSequence title;
        int type = 0;

        public Section(int firstPosition, CharSequence title) {
            this.firstPosition = firstPosition;
            this.title = title;
        }

        public CharSequence getTitle() {
            return this.title;
        }
    }
}

