/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.robotools.app;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import eu.livotov.labs.android.robotools.app.injector.RTInjector;

public class RTFragment
extends Fragment {
    private RTInjector.FragmentInjector injector = new RTInjector.FragmentInjector(this);
    private Activity hostActivity;

    public void onAttach(Context ctx) {
        super.onAttach(ctx);
        this.hostActivity = this.getActivity();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.hostActivity = activity;
    }

    public void onDetach() {
        super.onDetach();
        this.hostActivity = null;
    }

    public void startFragment(Fragment fragment) {
        if (fragment != null) {
            this.getFragmentManager().beginTransaction().replace(this.getId(), fragment).setTransition(8194).addToBackStack(fragment.toString()).commit();
        }
    }

    public void invalidateOptionsMenu() {
        if (this.hostActivity != null) {
            this.hostActivity.invalidateOptionsMenu();
        }
    }

    public void finishActivity() {
        if (this.hostActivity != null) {
            this.hostActivity.finish();
        }
    }

    public void finish() {
        this.getFragmentManager().popBackStack();
    }

    public void clearBackStack() {
        for (int i = 0; i < this.getFragmentManager().getBackStackEntryCount(); ++i) {
            this.getFragmentManager().popBackStackImmediate();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.injector.onCreate();
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return this.injector.onCreateView(inflater, container);
    }

    public void onStart() {
        super.onStart();
        this.injector.onStart();
    }

    public void onStop() {
        super.onStop();
        this.injector.onStop();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.injector.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.injector.onDestroy();
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        this.injector.onCreateOptionsMenu(menu, inflater);
        super.onCreateOptionsMenu(menu, inflater);
    }

    public void onDestroyOptionsMenu() {
        this.injector.onDestroyOptionsMenu();
        super.onDestroyOptionsMenu();
    }

    @TargetApi(value=17)
    public boolean isNestedFragment() {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.getParentFragment() != null;
        }
        return false;
    }

    public void showToast(@NonNull CharSequence text, boolean longToast) {
        Toast.makeText((Context)this.hostActivity, (CharSequence)text, (int)(longToast ? 1 : 0)).show();
    }

    public void showToast(int textId, boolean longToast) {
        Toast.makeText((Context)this.hostActivity, (int)textId, (int)(longToast ? 1 : 0)).show();
    }

    public boolean isActive() {
        return this.isAdded() && this.isVisible();
    }
}

