/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera.v1;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import eu.livotov.labs.android.camview.camera.CAMViewAsyncTask;
import java.util.ArrayList;
import java.util.Collection;

final class AutoFocusManager
implements Camera.AutoFocusCallback {
    private static final String TAG = AutoFocusManager.class.getSimpleName();
    private static final long AUTO_FOCUS_INTERVAL_MS = 2000L;
    private static final Collection<String> FOCUS_MODES_CALLING_AF = new ArrayList<String>(2);
    private boolean active;
    private final boolean useAutoFocus;
    private final Camera camera;
    private CAMViewAsyncTask<Object, Object, Object> outstandingTask;

    AutoFocusManager(Context context, Camera camera) {
        this.camera = camera;
        String currentFocusMode = camera.getParameters().getFocusMode();
        this.useAutoFocus = FOCUS_MODES_CALLING_AF.contains(currentFocusMode);
        this.start();
    }

    public synchronized void onAutoFocus(boolean success, Camera theCamera) {
        if (this.active) {
            this.outstandingTask = new AutoFocusTask();
            this.outstandingTask.execSerial((Object[])new Object[0]);
        }
    }

    synchronized void start() {
        if (this.useAutoFocus) {
            this.active = true;
            try {
                this.camera.autoFocus((Camera.AutoFocusCallback)this);
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while focusing", (Throwable)re);
            }
        }
    }

    synchronized void stop() {
        if (this.useAutoFocus) {
            try {
                this.camera.cancelAutoFocus();
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while cancelling focusing", (Throwable)re);
            }
        }
        if (this.outstandingTask != null) {
            this.outstandingTask.cancel();
            this.outstandingTask = null;
        }
        this.active = false;
    }

    static {
        FOCUS_MODES_CALLING_AF.add("auto");
        FOCUS_MODES_CALLING_AF.add("macro");
    }

    private final class AutoFocusTask
    extends CAMViewAsyncTask<Object, Object, Object> {
        private AutoFocusTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doInBackground(Object ... voids) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AutoFocusManager autoFocusManager = AutoFocusManager.this;
            synchronized (autoFocusManager) {
                if (AutoFocusManager.this.active) {
                    AutoFocusManager.this.start();
                }
            }
            return null;
        }
    }
}

