/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.FrameLayout;
import eu.livotov.labs.android.camview.ScannerLiveView;
import eu.livotov.labs.android.camview.camera.CameraController;
import eu.livotov.labs.android.camview.camera.CameraDelayedOperationResult;
import eu.livotov.labs.android.camview.camera.CameraInfo;
import eu.livotov.labs.android.camview.camera.CameraManager;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public class CameraLiveView
extends FrameLayout
implements SurfaceHolder.Callback {
    private CameraController camera;
    private SurfaceView surfaceView;
    private AtomicBoolean holderReady = new AtomicBoolean(false);
    private CameraLiveViewEventsListener cameraLiveViewEventsListener;

    public CameraLiveView(Context context) {
        super(context);
        this.initUI();
    }

    public CameraLiveView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initUI();
    }

    public CameraLiveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initUI();
    }

    @TargetApi(value=21)
    public CameraLiveView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initUI();
    }

    public CameraLiveViewEventsListener getCameraLiveViewEventsListener() {
        return this.cameraLiveViewEventsListener;
    }

    public void setCameraLiveViewEventsListener(CameraLiveViewEventsListener cameraLiveViewEventsListener) {
        this.cameraLiveViewEventsListener = cameraLiveViewEventsListener;
    }

    private void initUI() {
        this.surfaceView = new SurfaceView(this.getContext());
        if (Build.VERSION.SDK_INT < 11) {
            this.adjustSurfaceHolderPre11();
        }
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.addView((View)this.surfaceView);
    }

    @TargetApi(value=10)
    private void adjustSurfaceHolderPre11() {
        try {
            this.surfaceView.getHolder().setType(3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Collection<CameraInfo> getAvailableCameras() {
        return CameraManager.getAvailableCameras(this.getContext());
    }

    public void startCamera() {
        this.startCamera(null);
    }

    public void startCamera(CameraInfo camInfo) {
        CameraInfo finalCamera = camInfo;
        if (finalCamera == null) {
            finalCamera = CameraManager.findDefaultCamera(this.getContext());
        }
        if (finalCamera == null) {
            throw new RuntimeException("Cannot find any camera on device");
        }
        CameraManager.open(finalCamera, new CameraDelayedOperationResult(){

            @Override
            public void onOperationCompleted(CameraController controller) {
                block3: {
                    try {
                        CameraLiveView.this.setCamera(controller);
                        if (CameraLiveView.this.cameraLiveViewEventsListener != null) {
                            CameraLiveView.this.cameraLiveViewEventsListener.onCameraStarted(CameraLiveView.this);
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)ScannerLiveView.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
                        if (CameraLiveView.this.cameraLiveViewEventsListener == null) break block3;
                        CameraLiveView.this.cameraLiveViewEventsListener.onCameraError(e);
                    }
                }
            }

            @Override
            public void onOperationFailed(Throwable e, int cameraErrorCode) {
                Log.e((String)ScannerLiveView.class.getSimpleName(), (String)(e != null ? e.getMessage() : "n/a"));
                if (CameraLiveView.this.cameraLiveViewEventsListener != null) {
                    CameraLiveView.this.cameraLiveViewEventsListener.onCameraError(e != null ? e : new RuntimeException("Camera system error " + cameraErrorCode));
                }
            }
        });
    }

    public void stopCamera() {
        try {
            if (this.cameraLiveViewEventsListener != null) {
                this.cameraLiveViewEventsListener.onCameraStopped(this);
            }
            this.setCamera(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setCamera(CameraController camera) throws IOException {
        if (camera == null) {
            if (this.camera != null) {
                this.camera.close();
                this.camera = null;
            }
        } else {
            if (!camera.isReady()) {
                throw new IllegalArgumentException("Camera is not ready, please provide only initialized camera objects here !");
            }
            this.camera = camera;
            if (this.holderReady.get()) {
                camera.startPreview(this.surfaceView);
            }
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.holderReady.set(true);
        if (this.camera != null) {
            try {
                this.camera.startPreview(this.surfaceView);
            }
            catch (IOException e) {
                Log.e((String)CameraLiveView.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.camera != null) {
            this.camera.stopPreview();
            try {
                this.camera.startPreview(this.surfaceView);
            }
            catch (IOException e) {
                Log.e((String)CameraLiveView.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.holderReady.set(false);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.camera != null) {
            this.restartCameraOnConfigurationChanged();
        }
    }

    private void restartCameraOnConfigurationChanged() {
        this.camera.stopPreview();
        try {
            this.camera.startPreview(this.surfaceView);
        }
        catch (IOException e) {
            Log.e((String)CameraLiveView.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean resumeDisplay() {
        if (this.camera != null) {
            try {
                this.camera.startPreview(this.surfaceView);
                return true;
            }
            catch (IOException e) {
                Log.e((String)CameraLiveView.class.getSimpleName(), (String)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public void pauseDisplay() {
        if (this.camera != null) {
            this.camera.stopPreview();
        }
    }

    public CameraController getController() {
        return this.camera;
    }

    public static interface CameraLiveViewEventsListener {
        public void onCameraStarted(CameraLiveView var1);

        public void onCameraStopped(CameraLiveView var1);

        public void onCameraError(Throwable var1);
    }
}

