/*
 * Decompiled with CFR 0.152.
 */
package eu.livotov.labs.android.camview.camera.v1;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import eu.livotov.labs.android.camview.camera.AbstractController;
import eu.livotov.labs.android.camview.camera.CAMViewAsyncTask;
import eu.livotov.labs.android.camview.camera.CameraDelayedOperationResult;
import eu.livotov.labs.android.camview.camera.CameraInfo;
import eu.livotov.labs.android.camview.camera.LiveDataProcessingCallback;
import eu.livotov.labs.android.camview.camera.PictureProcessingCallback;
import eu.livotov.labs.android.camview.camera.v1.CameraUtilsV1;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultCameraV1Controller
extends AbstractController
implements Camera.PreviewCallback {
    private CameraInfo camera;
    private Camera rawCameraObject;
    private AtomicBoolean isOpen = new AtomicBoolean(false);
    private AtomicBoolean isInInitState = new AtomicBoolean(false);
    private byte[] previewBuffer;
    private SurfaceHolder surfaceHolder;
    private int previewFormat = 17;

    public DefaultCameraV1Controller(CameraInfo camera, CameraDelayedOperationResult callback) {
        this.camera = camera;
        this.open(callback);
    }

    @Override
    public boolean isReady() {
        return this.isOpen.get();
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final CameraDelayedOperationResult callback) {
        if (this.isOpen.get() && this.isInInitState.compareAndSet(false, true)) {
            new CAMViewAsyncTask(){
                int cameraErrorCode = 0;

                protected void onPostExecute(Object o) {
                    DefaultCameraV1Controller.this.isOpen.set(false);
                    DefaultCameraV1Controller.this.isInInitState.set(false);
                    DefaultCameraV1Controller.this.rawCameraObject = null;
                    if (callback != null) {
                        callback.onOperationCompleted(DefaultCameraV1Controller.this);
                    }
                }

                @Override
                protected void onError(Throwable t) {
                    DefaultCameraV1Controller.this.isInInitState.set(false);
                    if (callback != null) {
                        callback.onOperationFailed(t, this.cameraErrorCode);
                    }
                }

                protected Object doInBackground(Object[] args) throws Throwable {
                    if (DefaultCameraV1Controller.this.rawCameraObject != null) {
                        DefaultCameraV1Controller.this.rawCameraObject.setPreviewCallbackWithBuffer(null);
                        DefaultCameraV1Controller.this.rawCameraObject.setErrorCallback(null);
                        DefaultCameraV1Controller.this.rawCameraObject.stopPreview();
                        DefaultCameraV1Controller.this.rawCameraObject.release();
                    }
                    return null;
                }
            }.execSerial(new Object[0]);
        }
    }

    @Override
    public void startPreview(SurfaceView surfaceView) throws IOException {
        if (this.isCameraReadyForUserOperations()) {
            try {
                Camera.Parameters parameters = CameraUtilsV1.getMainCameraParameters(this.rawCameraObject);
                parameters.setPreviewFormat(this.previewFormat);
                this.rawCameraObject.setParameters(parameters);
            }
            catch (Throwable err) {
                Log.e((String)this.getClass().getSimpleName(), (String)"Master parameters set was rejected by a camera, trying failsafe one.", (Throwable)err);
                try {
                    Camera.Parameters parameters = CameraUtilsV1.getFailsafeCameraParameters(this.rawCameraObject);
                    parameters.setPreviewFormat(this.previewFormat);
                    this.rawCameraObject.setParameters(parameters);
                }
                catch (Throwable err2) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"Failsafe parameters set was rejected by a camera, trying to use it as is.", (Throwable)err2);
                }
            }
            if (this.surfaceHolder == null || this.surfaceHolder != surfaceView.getHolder()) {
                this.surfaceHolder = surfaceView.getHolder();
                this.rawCameraObject.setPreviewDisplay(this.surfaceHolder);
            }
            CameraUtilsV1.setupSurfaceAndCameraForPreview(Integer.parseInt(this.camera.getCameraId()), this.rawCameraObject, surfaceView);
            this.rawCameraObject.startPreview();
            this.rechargePreviewBuffer();
        }
    }

    @Override
    public void stopPreview() {
        if (this.isCameraReadyForUserOperations() && this.surfaceHolder != null) {
            this.stopLiveDataCapture();
            this.rawCameraObject.stopPreview();
            this.surfaceHolder = null;
        }
    }

    @Override
    public void requestLiveData(LiveDataProcessingCallback callback) {
        if (this.isCameraReadyForUserOperations()) {
            if (this.surfaceHolder != null && callback != null) {
                this.startLiveDataCapture(callback);
                this.rechargePreviewBuffer();
            } else {
                new IllegalStateException("Live data can only be requested after calling startPreview() !");
            }
        }
    }

    private void rechargePreviewBuffer() {
        int imageFormat = this.rawCameraObject.getParameters().getPreviewFormat();
        Camera.Size size = this.rawCameraObject.getParameters().getPreviewSize();
        if (imageFormat != 17) {
            throw new UnsupportedOperationException(String.format("Bad reported image format, wanted NV21 (%s) but got %s", 17, imageFormat));
        }
        int bufferSize = size.width * size.height * ImageFormat.getBitsPerPixel((int)imageFormat) / 8;
        if (this.previewBuffer == null || this.previewBuffer.length != bufferSize) {
            this.previewBuffer = new byte[bufferSize];
        }
        this.rawCameraObject.addCallbackBuffer(this.previewBuffer);
        this.rawCameraObject.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
    }

    @Override
    public void takePicture(final PictureProcessingCallback callback) {
        if (this.isCameraReadyForUserOperations()) {
            this.rawCameraObject.takePicture(new Camera.ShutterCallback(){

                public void onShutter() {
                    if (callback != null) {
                        callback.onShutterTriggered();
                    }
                }
            }, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    callback.onRawPictureTaken(data);
                }
            }, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    if (callback != null) {
                        callback.onPictureTaken(data);
                    }
                }
            });
        }
    }

    @Override
    public void switchFlashlight(boolean turnOn) {
        if (this.isCameraReadyForUserOperations()) {
            Camera.Parameters parameters = this.rawCameraObject.getParameters();
            if (parameters != null && parameters.getSupportedFlashModes() != null && parameters.getFlashMode() != null && parameters.getSupportedFlashModes().size() > 0) {
                if (turnOn) {
                    if (!parameters.getFlashMode().equals("torch")) {
                        parameters.setFlashMode("torch");
                    }
                } else if (!parameters.getFlashMode().equals("off")) {
                    parameters.setFlashMode("off");
                }
                this.rawCameraObject.setParameters(parameters);
            }
        } else {
            throw new IllegalAccessError("Camera is closed. Cannot toggle flash on non open camera.");
        }
    }

    @Override
    public void switchAutofocus(boolean useAutofocus) {
        if (this.isCameraReadyForUserOperations()) {
            // empty if block
        }
    }

    @Override
    public void requestFocus() {
        if (this.isCameraReadyForUserOperations()) {
            // empty if block
        }
    }

    private void open(final CameraDelayedOperationResult callback) {
        if (this.isOpen.get()) {
            return;
        }
        if (this.isInInitState.compareAndSet(false, true)) {
            new CAMViewAsyncTask(){
                private int cameraErrorCode = 0;

                @Override
                protected void onError(Throwable t) {
                    DefaultCameraV1Controller.this.isOpen.set(false);
                    DefaultCameraV1Controller.this.isInInitState.set(false);
                    if (callback != null) {
                        callback.onOperationFailed(t, this.cameraErrorCode);
                    }
                }

                protected void onPostExecute(Object o) {
                    DefaultCameraV1Controller.this.isOpen.set(true);
                    DefaultCameraV1Controller.this.isInInitState.set(false);
                    if (callback != null) {
                        callback.onOperationCompleted(DefaultCameraV1Controller.this);
                    }
                }

                protected Object doInBackground(Object[] args) throws Throwable {
                    DefaultCameraV1Controller.this.rawCameraObject = null;
                    int retriesCount = 5;
                    Throwable lastError = null;
                    while (DefaultCameraV1Controller.this.rawCameraObject == null && retriesCount > 0) {
                        try {
                            DefaultCameraV1Controller.this.rawCameraObject = Camera.open((int)Integer.parseInt(DefaultCameraV1Controller.this.camera.getCameraId()));
                        }
                        catch (Throwable openError) {
                            lastError = openError;
                            --retriesCount;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException itre) {}
                        }
                    }
                    if (DefaultCameraV1Controller.this.rawCameraObject == null) {
                        this.cameraErrorCode = -1;
                        throw lastError;
                    }
                    this.cameraErrorCode = 0;
                    return null;
                }
            }.execSerial(new Object[0]);
        }
    }

    private boolean isCameraReadyForUserOperations() {
        return this.isOpen.get() && !this.isInInitState.get();
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (this.liveFrameProcessingThread != null && data != null && this.isCameraReadyForUserOperations()) {
            Camera.Size size = this.rawCameraObject.getParameters().getPreviewSize();
            this.liveFrameProcessingThread.submitLiveFrame(data, size.width, size.height);
        }
    }
}

