/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.viewpager.widget.ViewPager;
import es.voghdev.pdfviewpager.library.R;
import es.voghdev.pdfviewpager.library.remote.DownloadFile;
import es.voghdev.pdfviewpager.library.remote.DownloadFileUrlConnectionImpl;
import es.voghdev.pdfviewpager.library.util.FileUtil;
import java.io.File;

public class RemotePDFViewPager
extends ViewPager
implements DownloadFile.Listener {
    protected Context context;
    protected DownloadFile downloadFile;
    protected DownloadFile.Listener listener;

    public RemotePDFViewPager(Context context, String pdfUrl, DownloadFile.Listener listener) {
        super(context);
        this.context = context;
        this.listener = listener;
        this.init(new DownloadFileUrlConnectionImpl(context, new Handler(), this), pdfUrl);
    }

    public RemotePDFViewPager(Context context, DownloadFile downloadFile, String pdfUrl, DownloadFile.Listener listener) {
        super(context);
        this.context = context;
        this.listener = listener;
        this.init(downloadFile, pdfUrl);
    }

    public RemotePDFViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    private void init(DownloadFile downloadFile, String pdfUrl) {
        this.setDownloader(downloadFile);
        downloadFile.download(pdfUrl, new File(this.context.getCacheDir(), FileUtil.extractFileNameFromURL(pdfUrl)).getAbsolutePath());
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.PDFViewPager);
            String pdfUrl = a.getString(R.styleable.PDFViewPager_pdfUrl);
            if (pdfUrl != null && pdfUrl.length() > 0) {
                this.init(new DownloadFileUrlConnectionImpl(this.context, new Handler(), this), pdfUrl);
            }
            a.recycle();
        }
    }

    public void setDownloader(DownloadFile downloadFile) {
        this.downloadFile = downloadFile;
    }

    @Override
    public void onSuccess(String url, String destinationPath) {
        this.listener.onSuccess(url, destinationPath);
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public void onProgressUpdate(int progress, int total) {
        this.listener.onProgressUpdate(progress, total);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    public class NullListener
    implements DownloadFile.Listener {
        @Override
        public void onSuccess(String url, String destinationPath) {
        }

        @Override
        public void onFailure(Exception e) {
        }

        @Override
        public void onProgressUpdate(int progress, int total) {
        }
    }
}

