/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import es.voghdev.pdfviewpager.library.R;
import es.voghdev.pdfviewpager.library.adapter.BasePDFPagerAdapter;
import es.voghdev.pdfviewpager.library.adapter.PdfScale;
import es.voghdev.pdfviewpager.library.util.EmptyClickListener;

public class PDFPagerAdapter
extends BasePDFPagerAdapter {
    private static final float DEFAULT_SCALE = 1.0f;
    PdfScale scale = new PdfScale();
    View.OnClickListener pageClickListener = new EmptyClickListener();

    public PDFPagerAdapter(Context context, String pdfPath) {
        super(context, pdfPath);
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View v = this.inflater.inflate(R.layout.view_pdf_page, container, false);
        SubsamplingScaleImageView ssiv = (SubsamplingScaleImageView)v.findViewById(R.id.subsamplingImageView);
        if (this.renderer == null || this.getCount() < position) {
            return v;
        }
        PdfRenderer.Page page = this.getPDFPage(this.renderer, position);
        Bitmap bitmap = this.bitmapContainer.get(position);
        ssiv.setImage(ImageSource.bitmap((Bitmap)bitmap));
        page.render(bitmap, null, null, 1);
        page.close();
        ((ViewPager)container).addView(v, 0);
        return v;
    }

    @Override
    public void close() {
        super.close();
    }

    public static class Builder {
        Context context;
        String pdfPath = "";
        float scale = 1.0f;
        float centerX = 0.0f;
        float centerY = 0.0f;
        int offScreenSize = 1;
        float renderQuality = 2.0f;
        View.OnClickListener pageClickListener = new EmptyClickListener();

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setScale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder setScale(PdfScale scale) {
            this.scale = scale.getScale();
            this.centerX = scale.getCenterX();
            this.centerY = scale.getCenterY();
            return this;
        }

        public Builder setCenterX(float centerX) {
            this.centerX = centerX;
            return this;
        }

        public Builder setCenterY(float centerY) {
            this.centerY = centerY;
            return this;
        }

        public Builder setRenderQuality(float renderQuality) {
            this.renderQuality = renderQuality;
            return this;
        }

        public Builder setOffScreenSize(int offScreenSize) {
            this.offScreenSize = offScreenSize;
            return this;
        }

        public Builder setPdfPath(String path) {
            this.pdfPath = path;
            return this;
        }

        public Builder setOnPageClickListener(View.OnClickListener listener) {
            if (listener != null) {
                this.pageClickListener = listener;
            }
            return this;
        }

        public PDFPagerAdapter create() {
            PDFPagerAdapter adapter = new PDFPagerAdapter(this.context, this.pdfPath);
            adapter.scale.setScale(this.scale);
            adapter.scale.setCenterX(this.centerX);
            adapter.scale.setCenterY(this.centerY);
            adapter.offScreenSize = this.offScreenSize;
            adapter.renderQuality = this.renderQuality;
            adapter.pageClickListener = this.pageClickListener;
            return adapter;
        }
    }
}

