/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import es.voghdev.pdfviewpager.library.PDFViewPager;
import es.voghdev.pdfviewpager.library.R;
import es.voghdev.pdfviewpager.library.adapter.PDFPagerAdapter;

public class PDFViewPagerZoom
extends PDFViewPager {
    public PDFViewPagerZoom(Context context, String pdfPath) {
        super(context, pdfPath);
    }

    public PDFViewPagerZoom(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void initAdapter(Context context, String pdfPath) {
        this.setAdapter(new PDFPagerAdapter.Builder(context).setPdfPath(pdfPath).setOffScreenSize(this.getOffscreenPageLimit()).create());
    }

    @Override
    protected void init(AttributeSet attrs) {
        if (this.isInEditMode()) {
            this.setBackgroundResource(R.drawable.flaticon_pdf_dummy);
            return;
        }
        if (attrs != null) {
            TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.PDFViewPager);
            String assetFileName = a.getString(R.styleable.PDFViewPager_assetFileName);
            float scale = a.getFloat(R.styleable.PDFViewPager_scale, 1.0f);
            if (assetFileName != null && assetFileName.length() > 0) {
                this.setAdapter(new PDFPagerAdapter.Builder(this.context).setPdfPath(assetFileName).setScale(scale).setOffScreenSize(this.getOffscreenPageLimit()).create());
            }
            a.recycle();
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }
}

