/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.adapter;

import android.graphics.Bitmap;
import es.voghdev.pdfviewpager.library.adapter.BitmapContainer;
import es.voghdev.pdfviewpager.library.adapter.PdfRendererParams;

public class SimpleBitmapPool
implements BitmapContainer {
    Bitmap[] bitmaps;
    private int poolSize;
    private int width;
    private int height;
    private Bitmap.Config config;

    public SimpleBitmapPool(PdfRendererParams params) {
        this.poolSize = this.getPoolSize(params.getOffScreenSize());
        this.width = params.getWidth();
        this.height = params.getHeight();
        this.config = params.getConfig();
        this.bitmaps = new Bitmap[this.poolSize];
    }

    private int getPoolSize(int offScreenSize) {
        return offScreenSize * 2 + 1;
    }

    public Bitmap getBitmap(int position) {
        int index = this.getIndexFromPosition(position);
        if (this.bitmaps[index] == null) {
            this.createBitmapAtIndex(index);
        }
        this.bitmaps[index].eraseColor(0);
        return this.bitmaps[index];
    }

    @Override
    public Bitmap get(int position) {
        return this.getBitmap(position);
    }

    @Override
    public void remove(int position) {
        this.bitmaps[position].recycle();
        this.bitmaps[position] = null;
    }

    @Override
    public void clear() {
        this.recycleAll();
    }

    protected void recycleAll() {
        for (int i = 0; i < this.poolSize; ++i) {
            if (this.bitmaps[i] == null) continue;
            this.bitmaps[i].recycle();
            this.bitmaps[i] = null;
        }
    }

    protected void createBitmapAtIndex(int index) {
        Bitmap bitmap;
        this.bitmaps[index] = bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)this.config);
    }

    protected int getIndexFromPosition(int position) {
        return position % this.poolSize;
    }
}

