/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.remote;

import android.content.Context;
import android.os.Handler;
import es.voghdev.pdfviewpager.library.remote.DownloadFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class DownloadFileUrlConnectionImpl
implements DownloadFile {
    private static final int KILOBYTE = 1024;
    private static final int BUFFER_LEN = 1024;
    private static final int NOTIFY_PERIOD = 153600;
    Context context;
    Handler uiThread;
    DownloadFile.Listener listener = new NullListener();

    public DownloadFileUrlConnectionImpl(Context context, Handler uiThread, DownloadFile.Listener listener) {
        this.context = context;
        this.uiThread = uiThread;
        this.listener = listener;
    }

    @Override
    public void download(final String url, final String destinationPath) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(destinationPath);
                    FileOutputStream fileOutput = new FileOutputStream(file);
                    HttpURLConnection urlConnection = null;
                    URL urlObj = new URL(url);
                    urlConnection = (HttpURLConnection)urlObj.openConnection();
                    int totalSize = urlConnection.getContentLength();
                    int downloadedSize = 0;
                    int counter = 0;
                    byte[] buffer = new byte[1024];
                    int bufferLength = 0;
                    BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                    while ((bufferLength = ((InputStream)in).read(buffer)) > 0) {
                        fileOutput.write(buffer, 0, bufferLength);
                        downloadedSize += bufferLength;
                        if (DownloadFileUrlConnectionImpl.this.listener == null || (counter += bufferLength) <= 153600) continue;
                        DownloadFileUrlConnectionImpl.this.notifyProgressOnUiThread(downloadedSize, totalSize);
                        counter = 0;
                    }
                    urlConnection.disconnect();
                    fileOutput.close();
                }
                catch (MalformedURLException e) {
                    DownloadFileUrlConnectionImpl.this.notifyFailureOnUiThread(e);
                }
                catch (IOException e) {
                    DownloadFileUrlConnectionImpl.this.notifyFailureOnUiThread(e);
                }
                DownloadFileUrlConnectionImpl.this.notifySuccessOnUiThread(url, destinationPath);
            }
        }).start();
    }

    protected void notifySuccessOnUiThread(final String url, final String destinationPath) {
        if (this.uiThread == null) {
            return;
        }
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                DownloadFileUrlConnectionImpl.this.listener.onSuccess(url, destinationPath);
            }
        });
    }

    protected void notifyFailureOnUiThread(final Exception e) {
        if (this.uiThread == null) {
            return;
        }
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                DownloadFileUrlConnectionImpl.this.listener.onFailure(e);
            }
        });
    }

    private void notifyProgressOnUiThread(final int downloadedSize, final int totalSize) {
        if (this.uiThread == null) {
            return;
        }
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                DownloadFileUrlConnectionImpl.this.listener.onProgressUpdate(downloadedSize, totalSize);
            }
        });
    }

    protected class NullListener
    implements DownloadFile.Listener {
        protected NullListener() {
        }

        @Override
        public void onSuccess(String url, String destinationPath) {
        }

        @Override
        public void onFailure(Exception e) {
        }

        @Override
        public void onProgressUpdate(int progress, int total) {
        }
    }
}

