/*
 * Decompiled with CFR 0.152.
 */
package es.voghdev.pdfviewpager.library.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import es.voghdev.pdfviewpager.library.R;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;

public class PDFPagerAdapter
extends PagerAdapter {
    String pdfPath;
    Context context;
    PdfRenderer renderer;
    SparseArray<WeakReference<Bitmap>> bitmaps;
    LayoutInflater inflater;

    public PDFPagerAdapter(Context context, String pdfPath) {
        this.pdfPath = pdfPath;
        this.context = context;
        this.bitmaps = new SparseArray();
        this.init();
    }

    protected void init() {
        try {
            this.renderer = new PdfRenderer(this.getSeekableFileDescriptor(this.pdfPath));
            this.inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)"PDFPagerAdapter", (String)e.getMessage());
        }
    }

    protected ParcelFileDescriptor getSeekableFileDescriptor(String path) throws IOException {
        ParcelFileDescriptor pfd;
        File pdfCopy = new File(path);
        if (pdfCopy.exists()) {
            ParcelFileDescriptor pfd2 = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
            return pfd2;
        }
        if (this.isAnAsset(path)) {
            pdfCopy = new File(this.context.getCacheDir(), path);
            pfd = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
        } else {
            URI uri = URI.create(String.format("file://%s", path));
            pfd = this.context.getContentResolver().openFileDescriptor(Uri.parse((String)uri.toString()), "rw");
        }
        return pfd;
    }

    private boolean isAnAsset(String path) {
        return !path.startsWith("/");
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View v = this.inflater.inflate(R.layout.view_pdf_page, container, false);
        ImageView iv = (ImageView)v.findViewById(R.id.imageView);
        if (this.renderer == null || this.getCount() < position) {
            return v;
        }
        PdfRenderer.Page page = this.getPDFPage(position);
        Bitmap bitmap = Bitmap.createBitmap((int)page.getWidth(), (int)page.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        page.render(bitmap, null, null, 1);
        page.close();
        this.bitmaps.put(position, new WeakReference<Bitmap>(bitmap));
        iv.setImageBitmap(bitmap);
        ((ViewPager)container).addView(v, 0);
        return v;
    }

    private PdfRenderer.Page getPDFPage(int position) {
        return this.renderer.openPage(position);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
    }

    public void close() {
        this.releaseAllBitmaps();
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    protected void releaseAllBitmaps() {
        for (int i = 0; this.bitmaps != null && i < this.bitmaps.size(); ++i) {
            this.recycleBitmap(this.bitmaps.keyAt(i));
        }
        this.bitmaps.clear();
    }

    protected void recycleBitmap(int position) {
        Bitmap b = (Bitmap)((WeakReference)this.bitmaps.get(position)).get();
        if (b != null && !b.isRecycled()) {
            b.recycle();
            this.bitmaps.remove(position);
        }
    }

    public int getCount() {
        return this.renderer != null ? this.renderer.getPageCount() : 0;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == (View)object;
    }
}

