/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.collation;

import dev.miku.r2dbc.mysql.collation.CharCollation;
import dev.miku.r2dbc.mysql.collation.CharsetTarget;
import dev.miku.r2dbc.mysql.util.AssertUtils;

abstract class AbstractCharCollation
implements CharCollation {
    protected final int id;
    protected final String name;
    final CharsetTarget target;

    AbstractCharCollation(int id, String name, CharsetTarget target) {
        this.id = id;
        this.name = AssertUtils.requireNonNull(name, "name must not be null");
        this.target = AssertUtils.requireNonNull(target, "target must not be null");
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public int getByteSize() {
        return this.target.getByteSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCharCollation)) {
            return false;
        }
        AbstractCharCollation that = (AbstractCharCollation)o;
        if (this.id != that.id) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.target.equals(that.target);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }
}

