/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.ByteCodec;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.IntegerCodec;
import dev.miku.r2dbc.mysql.codec.PrimitiveCodec;
import dev.miku.r2dbc.mysql.codec.ShortCodec;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class LongCodec
implements PrimitiveCodec<Long> {
    private final ByteBufAllocator allocator;

    LongCodec(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public Long decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        if (binary) {
            boolean isUnsigned = (info.getDefinitions() & 0x20) != 0;
            return LongCodec.decodeBinary(value, info.getType(), isUnsigned);
        }
        return LongCodec.parse(value);
    }

    @Override
    public boolean canDecode(FieldInformation info, Class<?> target) {
        short type = info.getType();
        if (!TypePredicates.isInt(type)) {
            return false;
        }
        if (8 == type && (info.getDefinitions() & 0x20) != 0) {
            return Long.class == target;
        }
        return target.isAssignableFrom(Long.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Long;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        long v = (Long)value;
        if ((long)((byte)v) == v) {
            return new ByteCodec.ByteParameter(this.allocator, (byte)v);
        }
        if ((long)((short)v) == v) {
            return new ShortCodec.ShortParameter(this.allocator, (short)v);
        }
        if ((long)((int)v) == v) {
            return new IntegerCodec.IntParameter(this.allocator, (int)v);
        }
        return new LongParameter(this.allocator, v);
    }

    @Override
    public boolean canPrimitiveDecode(FieldInformation info) {
        return TypePredicates.isInt(info.getType());
    }

    @Override
    public Class<Long> getPrimitiveClass() {
        return Long.TYPE;
    }

    static long parse(ByteBuf buf) {
        long value;
        boolean isNegative;
        byte first = buf.readByte();
        if (first == 45) {
            isNegative = true;
            value = 0L;
        } else if (first >= 48 && first <= 57) {
            isNegative = false;
            value = (long)first - 48L;
        } else {
            isNegative = false;
            value = 0L;
        }
        while (buf.isReadable()) {
            value = value * 10L + (long)(buf.readByte() - 48);
        }
        return isNegative ? -value : value;
    }

    private static long decodeBinary(ByteBuf buf, short type, boolean isUnsigned) {
        switch (type) {
            case 8: {
                return buf.readLongLE();
            }
            case 3: {
                if (isUnsigned) {
                    return buf.readUnsignedIntLE();
                }
                return buf.readIntLE();
            }
            case 9: {
                return buf.readIntLE();
            }
            case 2: {
                if (isUnsigned) {
                    return buf.readUnsignedShortLE();
                }
                return buf.readShortLE();
            }
            case 13: {
                return buf.readShortLE();
            }
        }
        if (isUnsigned) {
            return buf.readUnsignedByte();
        }
        return buf.readByte();
    }

    private static final class LongParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final long value;

        private LongParameter(ByteBufAllocator allocator, long value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = this.allocator.buffer(8);
                try {
                    return buf.writeLongLE(this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeLong(this.value));
        }

        @Override
        public short getType() {
            return 8;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LongParameter)) {
                return false;
            }
            LongParameter longValue = (LongParameter)o;
            return this.value == longValue.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }
}

