/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.codec;

import dev.miku.r2dbc.mysql.Parameter;
import dev.miku.r2dbc.mysql.ParameterWriter;
import dev.miku.r2dbc.mysql.codec.AbstractClassedCodec;
import dev.miku.r2dbc.mysql.codec.AbstractParameter;
import dev.miku.r2dbc.mysql.codec.CodecContext;
import dev.miku.r2dbc.mysql.codec.FieldInformation;
import dev.miku.r2dbc.mysql.codec.TypePredicates;
import dev.miku.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class BigDecimalCodec
extends AbstractClassedCodec<BigDecimal> {
    BigDecimalCodec(ByteBufAllocator allocator) {
        super(allocator, BigDecimal.class);
    }

    @Override
    public BigDecimal decode(ByteBuf value, FieldInformation info, Class<?> target, boolean binary, CodecContext context) {
        BigDecimal decimal;
        if (binary) {
            short type = info.getType();
            switch (type) {
                case 4: {
                    return BigDecimal.valueOf(value.readFloatLE());
                }
                case 5: {
                    return BigDecimal.valueOf(value.readDoubleLE());
                }
            }
        }
        if (BigDecimal.ZERO.equals(decimal = new BigDecimal(value.toString(StandardCharsets.US_ASCII)))) {
            return BigDecimal.ZERO;
        }
        if (BigDecimal.ONE.equals(decimal)) {
            return BigDecimal.ONE;
        }
        if (BigDecimal.TEN.equals(decimal)) {
            return BigDecimal.TEN;
        }
        return decimal;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigDecimal;
    }

    @Override
    public Parameter encode(Object value, CodecContext context) {
        return new BigDecimalParameter(this.allocator, (BigDecimal)value);
    }

    @Override
    protected boolean doCanDecode(FieldInformation info) {
        short type = info.getType();
        return TypePredicates.isDecimal(type) || 4 == type || 5 == type;
    }

    static ByteBuf encodeAscii(ByteBufAllocator alloc, String ascii) {
        int size = ascii.length();
        if (size == 0) {
            return alloc.buffer(1).writeByte(0);
        }
        ByteBuf buf = alloc.buffer(VarIntUtils.varIntBytes(size) + size);
        try {
            VarIntUtils.writeVarInt(buf, size);
            buf.writeCharSequence((CharSequence)ascii, StandardCharsets.US_ASCII);
            return buf;
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    private static final class BigDecimalParameter
    extends AbstractParameter {
        private final ByteBufAllocator allocator;
        private final BigDecimal value;

        private BigDecimalParameter(ByteBufAllocator allocator, BigDecimal value) {
            this.allocator = allocator;
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary() {
            return Mono.fromSupplier(() -> BigDecimalCodec.encodeAscii(this.allocator, this.value.toString()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeBigDecimal(this.value));
        }

        @Override
        public short getType() {
            return 246;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigDecimalParameter)) {
                return false;
            }
            BigDecimalParameter that = (BigDecimalParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

