/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql;

import dev.miku.r2dbc.mysql.MySqlConnectionConfiguration;
import dev.miku.r2dbc.mysql.MySqlConnectionFactory;
import dev.miku.r2dbc.mysql.OptionMapper;
import dev.miku.r2dbc.mysql.constant.SslMode;
import dev.miku.r2dbc.mysql.constant.ZeroDateOption;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.time.ZoneId;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;

public final class MySqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String MYSQL_DRIVER = "mysql";
    public static final Option<String> UNIX_SOCKET = Option.valueOf((String)"unixSocket");
    public static final Option<ZoneId> SERVER_ZONE_ID = Option.valueOf((String)"serverZoneId");
    public static final Option<ZeroDateOption> ZERO_DATE = Option.valueOf((String)"zeroDate");
    public static final Option<SslMode> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<HostnameVerifier> SSL_HOSTNAME_VERIFIER = Option.valueOf((String)"sslHostnameVerifier");
    public static final Option<String[]> TLS_VERSION = Option.valueOf((String)"tlsVersion");
    public static final Option<String> SSL_CA = Option.valueOf((String)"sslCa");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<CharSequence> SSL_KEY_PASSWORD = Option.sensitiveValueOf((String)"sslKeyPassword");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    public static final Option<Boolean> TCP_KEEP_ALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_NO_DELAY = Option.valueOf((String)"tcpNoDelay");
    public static final Option<Object> USE_SERVER_PREPARE_STATEMENT = Option.valueOf((String)"useServerPrepareStatement");
    public static final Option<Boolean> AUTODETECT_EXTENSIONS = Option.valueOf((String)"autodetectExtensions");

    public ConnectionFactory create(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MySqlConnectionFactory.from(MySqlConnectionFactoryProvider.setup(options));
    }

    public boolean supports(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MYSQL_DRIVER.equals(options.getValue(ConnectionFactoryOptions.DRIVER));
    }

    public String getDriver() {
        return MYSQL_DRIVER;
    }

    static MySqlConnectionConfiguration setup(ConnectionFactoryOptions options) {
        OptionMapper mapper = new OptionMapper(options);
        MySqlConnectionConfiguration.Builder builder = MySqlConnectionConfiguration.builder();
        mapper.requiredConsume(ConnectionFactoryOptions.USER, builder::user);
        mapper.consume(ConnectionFactoryOptions.PASSWORD, builder::password);
        mapper.from(UNIX_SOCKET).asString().into(builder::unixSocket).otherwise(() -> MySqlConnectionFactoryProvider.setupHost(builder, mapper));
        mapper.from(SERVER_ZONE_ID).asInstance(ZoneId.class, id -> ZoneId.of(id, ZoneId.SHORT_IDS)).into(builder::serverZoneId);
        mapper.from(TCP_KEEP_ALIVE).asBoolean().into(builder::tcpKeepAlive);
        mapper.from(TCP_NO_DELAY).asBoolean().into(builder::tcpNoDelay);
        mapper.from(ZERO_DATE).asInstance(ZeroDateOption.class, id -> ZeroDateOption.valueOf(id.toUpperCase())).into(builder::zeroDateOption);
        mapper.from(USE_SERVER_PREPARE_STATEMENT).servePrepare(enable -> {
            if (enable.booleanValue()) {
                builder.useServerPrepareStatement();
            } else {
                builder.useClientPrepareStatement();
            }
        }, builder::useServerPrepareStatement);
        mapper.from(AUTODETECT_EXTENSIONS).asBoolean().into(builder::autodetectExtensions);
        mapper.from(ConnectionFactoryOptions.CONNECT_TIMEOUT).asInstance(Duration.class, Duration::parse).into(builder::connectTimeout);
        mapper.from(ConnectionFactoryOptions.DATABASE).asString().into(builder::database);
        return builder.build();
    }

    private static void setupHost(MySqlConnectionConfiguration.Builder builder, OptionMapper mapper) {
        mapper.requiredConsume(ConnectionFactoryOptions.HOST, builder::host);
        mapper.from(ConnectionFactoryOptions.PORT).asInt().into(builder::port);
        mapper.from(ConnectionFactoryOptions.SSL).asBoolean().into(isSsl -> builder.sslMode(isSsl != false ? SslMode.REQUIRED : SslMode.DISABLED));
        mapper.from(SSL_MODE).asInstance(SslMode.class, id -> SslMode.valueOf(id.toUpperCase())).into(builder::sslMode);
        mapper.from(TLS_VERSION).asStrings().into(builder::tlsVersion);
        mapper.from(SSL_HOSTNAME_VERIFIER).asInstance(HostnameVerifier.class).into(builder::sslHostnameVerifier);
        mapper.from(SSL_CERT).asString().into(builder::sslCert);
        mapper.from(SSL_KEY).asString().into(builder::sslKey);
        mapper.consume(SSL_KEY_PASSWORD, builder::sslKeyPassword);
        mapper.from(SSL_CONTEXT_BUILDER_CUSTOMIZER).asInstance(Function.class).into(customizer -> builder.sslContextBuilderCustomizer((Function<SslContextBuilder, SslContextBuilder>)customizer));
        mapper.from(SSL_CA).asString().into(builder::sslCa);
    }
}

