/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.aspectj;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.aspectj.tools.ajdoc.Main;
import org.codehaus.mojo.aspectj.AjcHelper;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="aspectj-report", requiresDependencyResolution=ResolutionScope.COMPILE)
public class AjcReportMojo
extends AbstractMavenReport {
    @Parameter(defaultValue="aspectj-report", required=true)
    private String reportDirectory = "aspectj-report";
    @Parameter(defaultValue="src/main/aspect")
    private String aspectDirectory = "src/main/aspect";
    @Parameter(defaultValue="src/test/aspect")
    private String testAspectDirectory = "src/test/aspect";
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    private File basedir;
    @Parameter(required=true, readonly=true, defaultValue="${project.build.directory}")
    private File buildDirectory;
    private String[] includes;
    private String[] excludes;
    @Parameter
    private String ajdtBuildDefFile;
    @Parameter
    protected boolean packageScope;
    @Parameter
    protected boolean protectedScope;
    @Parameter
    protected boolean privateScope;
    @Parameter
    protected boolean publicScope;
    @Parameter
    protected String overview;
    @Parameter
    protected String doctitle;
    @Parameter
    protected boolean verbose;
    @Parameter(defaultValue="${mojo.java.target}")
    protected String complianceLevel;
    private List<String> ajcOptions = new ArrayList<String>();
    @Parameter(readonly=true, required=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeReport(Locale locale) throws MavenReportException {
        Set<String> includes;
        this.getLog().info((CharSequence)"Starting generating ajdoc");
        this.project.addCompileSourceRoot(this.basedir.getAbsolutePath() + "/" + this.aspectDirectory);
        this.project.addTestCompileSourceRoot(this.basedir.getAbsolutePath() + "/" + this.testAspectDirectory);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-classpath");
        arguments.add(AjcHelper.createClassPath(this.project, this.pluginArtifacts, this.getClasspathDirectories()));
        arguments.addAll(this.ajcOptions);
        try {
            includes = null != this.ajdtBuildDefFile ? AjcHelper.getBuildFilesForAjdtFile(this.ajdtBuildDefFile, this.basedir) : AjcHelper.getBuildFilesForSourceDirs(this.getSourceDirectories(), this.includes, this.excludes);
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("AspectJ Report failed", (Exception)((Object)e));
        }
        arguments.add("-d");
        arguments.add(StringUtils.replace((String)(this.getOutputDirectory() + "/" + this.reportDirectory), (String)"//", (String)"/"));
        arguments.addAll(includes);
        if (this.getLog().isDebugEnabled()) {
            StringBuilder command = new StringBuilder("Running : ajdoc ");
            for (String argument : arguments) {
                command.append(' ').append(argument);
            }
            this.getLog().debug((CharSequence)command);
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Main.setOutputWorkingDir((String)this.buildDirectory.getAbsolutePath());
            Main.main((String[])arguments.toArray(new String[0]));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    protected List<String> getSourceDirectories() {
        ArrayList<String> sourceDirectories = new ArrayList<String>();
        sourceDirectories.addAll(this.project.getCompileSourceRoots());
        sourceDirectories.addAll(this.project.getTestCompileSourceRoots());
        return sourceDirectories;
    }

    protected List<String> getClasspathDirectories() {
        return Arrays.asList(this.project.getBuild().getOutputDirectory(), this.project.getBuild().getTestOutputDirectory());
    }

    public String getOutputName() {
        return "index";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.aspectj.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.aspectj.description");
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        return "java".equals(artifactHandler.getLanguage());
    }

    public void setOverview(String overview) {
        this.ajcOptions.add("-overview");
        this.ajcOptions.add(overview);
    }

    public void setDoctitle(String doctitle) {
        this.ajcOptions.add("-doctitle");
        this.ajcOptions.add(doctitle);
    }

    public void setPackageScope(boolean packageScope) {
        if (packageScope) {
            this.ajcOptions.add("-package");
        }
    }

    public void setPrivateScope(boolean privateScope) {
        if (privateScope) {
            this.ajcOptions.add("-private");
        }
    }

    public void setProtectedScope(boolean protectedScope) {
        if (protectedScope) {
            this.ajcOptions.add("-protected");
        }
    }

    public void setPublicScope(boolean publicScope) {
        if (publicScope) {
            this.ajcOptions.add("-public");
        }
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.ajcOptions.add("-verbose");
        }
    }

    public void setComplianceLevel(String complianceLevel) {
        if (AjcHelper.isValidComplianceLevel(complianceLevel)) {
            this.ajcOptions.add("-source");
            this.ajcOptions.add(complianceLevel);
        }
    }

    public void setPluginArtifacts(List<Artifact> pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("aspectj-report", locale);
    }
}

