/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter.internal;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import mva2.adapter.MultiViewAdapter;

public class DecorationDelegate
extends RecyclerView.ItemDecoration {
    private final MultiViewAdapter adapter;

    public DecorationDelegate(MultiViewAdapter adapter) {
        this.adapter = adapter;
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int adapterPosition = parent.getChildAdapterPosition(child);
            if (adapterPosition < 0) {
                return;
            }
            this.adapter.drawDecoration(canvas, parent, state, child, adapterPosition);
        }
    }

    public void onDrawOver(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int adapterPosition = parent.getChildAdapterPosition(child);
            if (adapterPosition < 0) {
                return;
            }
            this.adapter.drawDecorationOver(canvas, parent, state, child, adapterPosition);
        }
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int adapterPosition = parent.getChildAdapterPosition(view);
        if (adapterPosition < 0) {
            return;
        }
        this.adapter.getDecorationOffset(outRect, view, parent, state, adapterPosition);
    }
}

