/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter;

import android.support.annotation.NonNull;
import mva2.adapter.ItemSection;
import mva2.adapter.NestedSection;
import mva2.adapter.Section;
import mva2.adapter.decorator.Decorator;
import mva2.adapter.decorator.SectionPositionType;
import mva2.adapter.internal.Notifier;
import mva2.adapter.util.Mode;

public class TreeSection<M>
extends NestedSection
implements Notifier {
    private final ItemSection<M> itemSection;
    private Decorator treeDecorator;

    public TreeSection(M item) {
        this.itemSection = new ItemSection<M>(item);
        this.itemSection.setNotifier(this);
        this.sections.add(this.itemSection);
        this.setSectionExpansionMode(Mode.MULTIPLE);
    }

    public TreeSection getChild(int index) {
        return (TreeSection)this.sections.get(index);
    }

    public M getParent() {
        return this.itemSection.getItem();
    }

    public void setTreeDecorator(Decorator treeDecorator) {
        this.treeDecorator = treeDecorator;
        for (Section section : this.sections) {
            if (!(section instanceof TreeSection)) continue;
            ((TreeSection)section).setTreeDecorator(treeDecorator);
        }
    }

    @Override
    public void addSection(Section section) {
        if (!(section instanceof TreeSection)) {
            throw new IllegalArgumentException();
        }
        this.addTreeSection((TreeSection)section);
        if (null != this.treeDecorator) {
            ((TreeSection)section).setTreeDecorator(this.treeDecorator);
        }
    }

    @Override
    void collapseSection() {
        if (this.isSectionExpanded()) {
            this.onSectionExpansionToggled(0, this.sectionExpansionMode);
        }
    }

    @Override
    int getCount() {
        if (this.isSectionVisible()) {
            return super.getCount();
        }
        return this.itemSection.getCount();
    }

    @Override
    SectionPositionType getSectionPositionType(int adapterPosition, int sectionPosition, int size) {
        return SectionPositionType.MIDDLE;
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        if (itemPosition < this.getCount() && itemPosition >= 0) {
            if (itemPosition == 0) {
                int count = this.getChildCount() - 1;
                this.setSectionExpanded(!this.isSectionExpanded());
                if (this.isSectionExpanded()) {
                    this.onInserted(1, count);
                } else {
                    this.onRemoved(1, count);
                }
            } else {
                this.onChildSectionExpansionToggled(itemPosition, this.sectionExpansionMode);
            }
        }
        return itemPosition - this.getCount();
    }

    private void addTreeSection(TreeSection section) {
        section.setNotifier(this);
        section.addDecorator(this.treeDecorator);
        this.sections.add(section);
    }

    private int getChildCount() {
        int itemCount = 0;
        for (Section section : this.sections) {
            itemCount += section.getCount();
        }
        return itemCount;
    }
}

