/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import mva2.adapter.Section;
import mva2.adapter.internal.ItemMetaData;
import mva2.adapter.internal.RecyclerItem;
import mva2.adapter.util.Mode;

public class ItemSection<M>
extends Section {
    private M item;
    private ItemMetaData itemMetaData;

    public ItemSection() {
    }

    public ItemSection(M item) {
        this.item = item;
        this.itemMetaData = new ItemMetaData();
    }

    @Nullable
    public M getItem() {
        return this.item;
    }

    public void removeItem() {
        this.item = null;
        this.itemMetaData = null;
        this.onRemoved(0, 1);
    }

    public void setItem(@NonNull M item) {
        if (item == null) {
            return;
        }
        if (null == this.itemMetaData) {
            this.itemMetaData = new ItemMetaData();
            this.item = item;
            this.onInserted(0, 1);
        } else {
            this.item = item;
            this.onChanged(0, 1, null);
        }
    }

    @Override
    Object getItem(int position) {
        return this.item;
    }

    @Override
    int getCount() {
        return this.isItemShowing() ? 1 : 0;
    }

    @Override
    boolean isItemSelected(int adapterPosition) {
        return this.itemMetaData.isSelected();
    }

    @Override
    void onItemSelectionToggled(int itemPosition, @NonNull Mode selectionMode) {
        if (itemPosition < this.getCount()) {
            Mode modeToHonor = this.getModeToHonor(selectionMode, this.selectionMode);
            if (modeToHonor == Mode.SINGLE && this.itemMetaData.isSelected()) {
                this.itemMetaData.setSelected(!this.itemMetaData.isSelected());
                this.onChanged(0, 1, null);
            } else if (itemPosition < this.getCount() && itemPosition >= 0) {
                this.itemMetaData.setSelected(!this.itemMetaData.isSelected());
                this.onChanged(0, 1, null);
            }
        }
    }

    @Override
    void clearAllSelections() {
        if (this.itemMetaData.isSelected()) {
            this.itemMetaData.setSelected(!this.itemMetaData.isSelected());
            if (this.isItemShowing()) {
                this.onChanged(0, 1, null);
            }
        }
    }

    @Override
    boolean isItemExpanded(int adapterPosition) {
        return this.itemMetaData.isExpanded();
    }

    @Override
    void onItemExpansionToggled(int itemPosition, @NonNull Mode selectionMode) {
        if (itemPosition < this.getCount()) {
            Mode modeToHonor = this.getModeToHonor(selectionMode, this.expansionMode);
            if (modeToHonor == Mode.SINGLE && this.itemMetaData.isExpanded()) {
                this.itemMetaData.setExpanded(!this.itemMetaData.isExpanded());
                this.onChanged(0, 1, null);
            } else if (itemPosition < this.getCount() && itemPosition >= 0) {
                this.itemMetaData.setExpanded(!this.itemMetaData.isExpanded());
                this.onChanged(0, 1, null);
            }
        }
    }

    @Override
    void collapseAllItems() {
        if (this.itemMetaData.isExpanded()) {
            this.itemMetaData.setExpanded(!this.itemMetaData.isExpanded());
            if (this.isItemShowing()) {
                this.onChanged(0, 1, null);
            }
        }
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        return itemPosition - this.getCount();
    }

    @Override
    int getPositionType(int itemPosition, int adapterPosition, RecyclerView.LayoutManager layoutManager) {
        return 15;
    }

    @Override
    void onItemDismiss(int itemPosition) {
        this.itemMetaData = null;
        this.item = null;
        this.onRemoved(itemPosition, 1);
    }

    @Override
    boolean move(int itemPosition, int targetOffset) {
        return false;
    }

    @Override
    RecyclerItem startMovingItem(int itemPosition) {
        RecyclerItem<M> recyclerItem = new RecyclerItem<M>(this.item, this.itemMetaData);
        this.item = null;
        this.itemMetaData = null;
        return recyclerItem;
    }

    @Override
    void finishMovingItem(int currentPosition, RecyclerItem itemToMove) {
        this.item = itemToMove.getItem();
        this.itemMetaData = itemToMove.getItemMetaData();
    }

    private boolean isItemShowing() {
        return this.isSectionVisible() && this.item != null;
    }
}

