/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import mva2.adapter.ItemViewHolder;
import mva2.adapter.MultiViewAdapter;
import mva2.adapter.decorator.Decorator;

public abstract class ItemBinder<M, VH extends ItemViewHolder<M>> {
    private List<Decorator> decorators = new ArrayList<Decorator>();

    public ItemBinder() {
    }

    public ItemBinder(Decorator decorator) {
        this.addDecorator(decorator);
    }

    public void addDecorator(@NonNull Decorator decorator) {
        this.addDecorator(decorator, -1);
    }

    public void addDecorator(@NonNull Decorator decorator, int priority) {
        if (null == decorator) {
            return;
        }
        if (null == this.decorators) {
            this.decorators = new ArrayList<Decorator>();
        }
        if (priority >= 0 && this.decorators.size() > priority) {
            this.decorators.add(priority, decorator);
        } else {
            this.decorators.add(decorator);
        }
    }

    public void bindViewHolder(VH holder, M item, List payloads) {
        this.bindViewHolder(holder, item);
    }

    public int getSpanSize(int maxSpanCount) {
        return 1;
    }

    public View inflate(@NonNull ViewGroup parent, @LayoutRes int layoutResId) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResId, parent, false);
    }

    public void initViewHolder(VH holder) {
    }

    public void removeAllDecorators() {
        this.decorators.clear();
    }

    public boolean removeDecorator(Decorator decorator) {
        return this.decorators.remove(decorator);
    }

    public void removeDecorator(int index) {
        this.decorators.remove(index);
    }

    public abstract VH createViewHolder(ViewGroup var1);

    public abstract void bindViewHolder(VH var1, M var2);

    public abstract boolean canBindData(Object var1);

    VH createViewHolder(ViewGroup parent, MultiViewAdapter adapter) {
        VH viewHolder = this.createViewHolder(parent);
        ((ItemViewHolder)((Object)viewHolder)).setAdapter(adapter);
        this.initViewHolder(viewHolder);
        return viewHolder;
    }

    void drawItemDecoration(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        for (Decorator decorator : this.decorators) {
            decorator.onDraw(canvas, parent, state, child, adapterPosition);
        }
    }

    void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        for (Decorator decorator : this.decorators) {
            decorator.getItemOffsets(outRect, view, parent, state, adapterPosition);
        }
    }
}

