/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import mva2.adapter.ItemSection;
import mva2.adapter.ListSection;
import mva2.adapter.NestedSection;
import mva2.adapter.internal.Notifier;
import mva2.adapter.util.Mode;

public class HeaderSection<H, M>
extends NestedSection
implements Notifier {
    private final ItemSection<H> itemSection = new ItemSection();
    private final ListSection<M> listSection;

    public HeaderSection() {
        this.itemSection.setNotifier(this);
        this.listSection = new ListSection();
        this.listSection.setNotifier(this);
        this.addSection(this.itemSection);
        this.addSection(this.listSection);
    }

    public HeaderSection(@NonNull H header) {
        this();
        this.itemSection.setItem(header);
    }

    public H getHeader() {
        return this.itemSection.getItem();
    }

    public ListSection<M> getListSection() {
        return this.listSection;
    }

    public void setHeader(@NonNull H header) {
        this.itemSection.setItem(header);
    }

    @Override
    void collapseSection() {
        if (this.listSection.isSectionExpanded()) {
            this.listSection.setSectionExpanded(false);
            this.onRemoved(1, this.listSection.size());
            this.onChanged(0, 1, null);
        }
    }

    @Override
    boolean isSectionExpanded(int itemPosition) {
        return this.listSection.isSectionExpanded();
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        Mode mode = this.getModeToHonor(sectionExpansionMode, this.sectionExpansionMode);
        int prevCount = this.getCount();
        switch (mode) {
            case SINGLE: {
                if (itemPosition < this.getCount() && itemPosition >= 0) {
                    this.listSection.setSectionExpanded(!this.listSection.isSectionExpanded());
                    if (this.listSection.isSectionExpanded()) {
                        this.onInserted(1, this.listSection.size());
                    } else {
                        this.onRemoved(1, this.listSection.size());
                    }
                    this.onChanged(0, 1, null);
                } else if (this.listSection.isSectionExpanded()) {
                    this.listSection.setSectionExpanded(!this.listSection.isSectionExpanded());
                    this.onRemoved(1, this.listSection.size());
                    this.onChanged(0, 1, null);
                }
                return itemPosition - prevCount;
            }
            case MULTIPLE: {
                if (itemPosition < this.getCount() && itemPosition >= 0) {
                    this.listSection.setSectionExpanded(!this.listSection.isSectionExpanded());
                    if (this.listSection.isSectionExpanded()) {
                        this.onInserted(1, this.listSection.size());
                    } else {
                        this.onRemoved(1, this.listSection.size());
                    }
                    this.onChanged(0, 1, null);
                }
                return itemPosition - prevCount;
            }
        }
        return itemPosition - prevCount;
    }

    @Override
    int getPositionType(int itemPosition, int adapterPosition, RecyclerView.LayoutManager layoutManager) {
        int result = super.getPositionType(itemPosition, adapterPosition, layoutManager);
        if (itemPosition == 0 && this.getCount() > 1) {
            result ^= 8;
        } else if (itemPosition != 0 && (result & 2) == 2) {
            result ^= 2;
        }
        return result;
    }
}

