/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgresPreparer;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.FluentConfiguration;

public final class FlywayPreparer
implements EmbeddedPostgresPreparer<DataSource> {
    private final ImmutableList.Builder<Consumer<FluentConfiguration>> customizers = ImmutableList.builder();

    @Nonnull
    public static FlywayPreparer forClasspathLocation(String ... locations) {
        FlywayPreparer preparer = new FlywayPreparer();
        preparer.addCustomizer(c -> c.locations(locations));
        return preparer;
    }

    @Nonnull
    public FlywayPreparer addCustomizer(@Nonnull Consumer<FluentConfiguration> customizer) {
        Preconditions.checkNotNull(customizer, (Object)"customizer is null");
        this.customizers.add(customizer);
        return this;
    }

    @Nonnull
    public FlywayPreparer addCustomizers(@Nonnull Set<Consumer<FluentConfiguration>> customizers) {
        Preconditions.checkNotNull(customizers, (Object)"customizers is null");
        customizers.addAll(customizers);
        return this;
    }

    @Override
    public void prepare(@Nonnull DataSource dataSource) throws IOException {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource is null");
        try {
            FluentConfiguration config = Flyway.configure();
            this.customizers.build().forEach(c -> c.accept(config));
            config.dataSource(dataSource);
            Flyway flyway = config.load();
            flyway.migrate();
        }
        catch (FlywayException e) {
            throw new IOException(e);
        }
    }
}

