/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.sisu.bean;

import de.softwareforge.testing.maven.org.eclipse.sisu.bean.$BeanLifecycle;
import de.softwareforge.testing.maven.org.eclipse.sisu.bean.$BeanManager;
import de.softwareforge.testing.maven.org.eclipse.sisu.bean.$BeanProperty;
import de.softwareforge.testing.maven.org.eclipse.sisu.bean.$BeanScheduler;
import de.softwareforge.testing.maven.org.eclipse.sisu.bean.$LifecycleBuilder;
import de.softwareforge.testing.maven.org.eclipse.sisu.bean.$PropertyBinding;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class $LifecycleManager
extends $BeanScheduler
implements $BeanManager {
    private final $LifecycleBuilder builder = new $LifecycleBuilder();
    private final Map<Class<?>, $BeanLifecycle> lifecycles = new ConcurrentHashMap(16, 0.75f, 1);
    private final Deque<Object> stoppableBeans = new ArrayDeque<Object>();

    @Override
    public boolean manage(Class<?> clazz) {
        return this.buildLifecycle(clazz);
    }

    @Override
    public $PropertyBinding manage($BeanProperty<?> property) {
        return null;
    }

    @Override
    public boolean manage(Object bean) {
        $BeanLifecycle lifecycle = this.lifecycleFor(bean);
        if (lifecycle.isStoppable()) {
            this.pushStoppable(bean);
        }
        if (lifecycle.isStartable()) {
            this.schedule(bean);
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (this.removeStoppable(bean)) {
            this.lifecycleFor(bean).stop(bean);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = this.popStoppable()) != null) {
            this.lifecycleFor(bean).stop(bean);
        }
        return true;
    }

    @Override
    protected void activate(Object bean) {
        this.lifecycleFor(bean).start(bean);
    }

    private boolean buildLifecycle(Class<?> clazz) {
        $BeanLifecycle lifecycle = this.lifecycles.get(clazz);
        if (null == lifecycle) {
            lifecycle = this.builder.build(clazz);
            this.lifecycles.put(clazz, lifecycle);
        }
        return lifecycle != $BeanLifecycle.NO_OP;
    }

    private $BeanLifecycle lifecycleFor(Object bean) {
        if (null != bean) {
            for (Class<?> c = bean.getClass(); null != c && c != Object.class; c = c.getSuperclass()) {
                $BeanLifecycle lifecycle = this.lifecycles.get(c);
                if (null == lifecycle) continue;
                return lifecycle;
            }
        }
        return $BeanLifecycle.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushStoppable(Object bean) {
        Deque<Object> deque = this.stoppableBeans;
        synchronized (deque) {
            this.stoppableBeans.addLast(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeStoppable(Object bean) {
        Deque<Object> deque = this.stoppableBeans;
        synchronized (deque) {
            return this.stoppableBeans.remove(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object popStoppable() {
        Deque<Object> deque = this.stoppableBeans;
        synchronized (deque) {
            return this.stoppableBeans.pollLast();
        }
    }

    public void flushCacheFor(ClassTester remove) {
        Iterator<Class<?>> iterator = this.lifecycles.keySet().iterator();
        while (iterator.hasNext()) {
            if (!remove.shouldFlush(iterator.next())) continue;
            iterator.remove();
        }
    }

    public static interface ClassTester {
        public boolean shouldFlush(Class<?> var1);
    }
}

